/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class FinalLocalVariableCheck
extends Check {
    private Stack mScopeStack = new Stack();

    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 10, 11, 12, 84, 7, 6};
    }

    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 11, 12, 84, 7, 6};
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 84: {
                this.mScopeStack.push(new HashMap());
                break;
            }
            case 10: 
            case 21: {
                if (aAST.getParent().getType() == 6) break;
                this.insertVariable(aAST);
                break;
            }
            case 58: {
                int parentType = aAST.getParent().getType();
                if (26 != parentType && 130 != parentType && 25 != parentType && 129 != parentType && 80 != parentType && 98 != parentType && 99 != parentType && 101 != parentType && 100 != parentType && 102 != parentType && 103 != parentType && 104 != parentType && 105 != parentType && 107 != parentType && 108 != parentType && 106 != parentType) break;
                this.removeVariable(aAST);
                break;
            }
        }
    }

    private void insertVariable(DetailAST aAST) {
        if (!aAST.branchContains(39)) {
            HashMap state = (HashMap)this.mScopeStack.peek();
            DetailAST ast = aAST.findFirstToken(58);
            state.put(ast.getText(), ast);
        }
    }

    private void removeVariable(DetailAST aAST) {
        HashMap state;
        Object obj;
        for (int i = this.mScopeStack.size() - 1; i >= 0 && (obj = (state = (HashMap)this.mScopeStack.get(i)).remove(aAST.getText())) == null; --i) {
        }
    }

    public void leaveToken(DetailAST aAST) {
        super.leaveToken(aAST);
        switch (aAST.getType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 84: {
                HashMap state = (HashMap)this.mScopeStack.pop();
                Iterator finalVars = state.values().iterator();
                while (finalVars.hasNext()) {
                    DetailAST var = (DetailAST)finalVars.next();
                    this.log(var.getLineNo(), var.getColumnNo(), "final.variable", (Object)var.getText());
                }
                break;
            }
        }
    }
}

