/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.IColumnFilter;

public abstract class AbstractTableMetaData
implements ITableMetaData {
    private static final Column[] EMPTY_COLUMNS = new Column[0];

    protected static Column[] getPrimaryKeys(Column[] columns, String[] keyNames) {
        if (keyNames == null || keyNames.length == 0) {
            return EMPTY_COLUMNS;
        }
        ArrayList<Column> keyList = new ArrayList<Column>();
        for (int i = 0; i < keyNames.length; ++i) {
            Column primaryKey = DataSetUtils.getColumn(keyNames[i], columns);
            if (primaryKey == null) continue;
            keyList.add(primaryKey);
        }
        return keyList.toArray(new Column[0]);
    }

    protected static Column[] getPrimaryKeys(String tableName, Column[] columns, IColumnFilter columnFilter) {
        ArrayList<Column> keyList = new ArrayList<Column>();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!columnFilter.accept(tableName, column)) continue;
            keyList.add(column);
        }
        return keyList.toArray(new Column[0]);
    }

    public abstract /* synthetic */ Column[] getPrimaryKeys() throws DataSetException;

    public abstract /* synthetic */ Column[] getColumns() throws DataSetException;

    public abstract /* synthetic */ String getTableName();
}

