/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public class CsvProducer
implements IDataSetProducer {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private String _theDirectory;

    public CsvProducer(String theDirectory) {
        this._theDirectory = theDirectory;
    }

    public CsvProducer(File theDirectory) {
        this._theDirectory = theDirectory.getAbsolutePath();
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        File dir = new File(this._theDirectory);
        if (!dir.isDirectory()) {
            throw new DataSetException("'" + this._theDirectory + "' should be a directory");
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".csv") && !dir.isFile();
            }
        };
        this._consumer.startDataSet();
        File[] children = dir.listFiles(filter);
        for (int i = 0; i < children.length; ++i) {
            try {
                this.produceFromFile(children[i]);
                continue;
            }
            catch (CsvParserException e) {
                throw new DataSetException(e);
            }
        }
        this._consumer.endDataSet();
    }

    private void produceFromFile(File theDataFile) throws DataSetException, CsvParserException {
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(theDataFile);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            for (int i = 0; i < readColumns.size(); ++i) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
            }
            String tableName = theDataFile.getName().substring(0, theDataFile.getName().indexOf(".csv"));
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this._consumer.startTable(metaData);
            for (int i = 1; i < readData.size(); ++i) {
                List rowList = (List)readData.get(i);
                this._consumer.row(rowList.toArray());
            }
            this._consumer.endTable();
        }
        catch (PipelineException e) {
            throw new DataSetException(e);
        }
        catch (IllegalInputCharacterException e) {
            throw new DataSetException(e);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }
}

