/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.QuantumPlugin;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BookmarkSelectionUtil {
    private static BookmarkSelectionUtil instance = new BookmarkSelectionUtil();
    private static final String OLD_LAST_USED_BOOKMARK_PREFERENCE;
    private static final String LAST_USED_BOOKMARK_PREFERENCE;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        OLD_LAST_USED_BOOKMARK_PREFERENCE = String.valueOf(clazz.getName()) + ".bookmark";
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.quantum.actions.BookmarkSelectionUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LAST_USED_BOOKMARK_PREFERENCE = String.valueOf(clazz2.getName()) + ".bookmark";
    }

    public static BookmarkSelectionUtil getInstance() {
        return instance;
    }

    public void setLastUsedBookmark(Bookmark bookmark) {
        String lastUsedBookmarkName = this.getLastUsedBookmarkName();
        QuantumPlugin.getDefault().getPreferenceStore().setValue(LAST_USED_BOOKMARK_PREFERENCE, bookmark.getName());
        if (lastUsedBookmarkName == null && bookmark != null || lastUsedBookmarkName != null && bookmark != null && !lastUsedBookmarkName.equals(bookmark.getName())) {
            this.propertyChangeSupport.firePropertyChange("lastUsedBookmark", null, bookmark);
        }
    }

    public Bookmark getLastUsedBookmark() {
        String lastUsedName = this.getLastUsedBookmarkName();
        return lastUsedName == null || lastUsedName.trim().length() == 0 ? null : BookmarkCollection.getInstance().find(lastUsedName);
    }

    private String getLastUsedBookmarkName() {
        String lastUsedName1 = QuantumPlugin.getDefault().getPreferenceStore().getString(LAST_USED_BOOKMARK_PREFERENCE);
        String lastUsedName = lastUsedName1;
        if (lastUsedName == null || lastUsedName.trim().length() == 0) {
            lastUsedName = this.getLastUsedBookmarkFromOlderVersionOfQuantum();
        }
        return lastUsedName;
    }

    private String getLastUsedBookmarkFromOlderVersionOfQuantum() {
        String lastUsedName = QuantumPlugin.getDefault().getPreferenceStore().getString(OLD_LAST_USED_BOOKMARK_PREFERENCE);
        if (lastUsedName != null && lastUsedName.trim().length() > 0) {
            QuantumPlugin.getDefault().getPreferenceStore().setValue(LAST_USED_BOOKMARK_PREFERENCE, lastUsedName);
            QuantumPlugin.getDefault().getPreferenceStore().setToDefault(OLD_LAST_USED_BOOKMARK_PREFERENCE);
        }
        return lastUsedName;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

