/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.actions.BookmarkAction;
import com.quantum.actions.BookmarkSelectionUtil;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.util.DisplayableComparator;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class BookmarkSubActionFactory {
    BookmarkSubActionFactory() {
    }

    public static Menu populateDropDownMenu(final BookmarkAction bookmarkAction, Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                BookmarkSubActionFactory.createSubActions(bookmarkAction, menu);
            }
        });
        return menu;
    }

    public static void createSubActions(BookmarkAction bookmarkAction, Menu menu) {
        Bookmark lastUsedBookmark = BookmarkSelectionUtil.getInstance().getLastUsedBookmark();
        if (lastUsedBookmark != null) {
            BookmarkSubActionFactory.createSubAction(bookmarkAction, menu, lastUsedBookmark);
            Separator separator = new Separator();
            separator.fill(menu, -1);
        }
        Bookmark[] bookmarks = BookmarkCollection.getInstance().getBookmarks();
        Arrays.sort(bookmarks, new DisplayableComparator());
        int i = 0;
        int length = bookmarks == null ? 0 : bookmarks.length;
        while (i < length) {
            Bookmark bookmark = bookmarks[i];
            BookmarkSubActionFactory.createSubAction(bookmarkAction, menu, bookmark);
            ++i;
        }
    }

    public static void createSubAction(final BookmarkAction bookmarkAction, Menu menu, final Bookmark bookmark) {
        Action action = new Action(){

            public void run() {
                bookmarkAction.execute(bookmark);
            }
        };
        action.setImageDescriptor(ImageStore.getImageDescriptor("bookmarks"));
        action.setEnabled(bookmarkAction.isEnabled(bookmark));
        if (bookmark.getName().indexOf(64) >= 0) {
            action.setText(String.valueOf(bookmark.getName()) + '@');
        } else {
            action.setText(bookmark.getName());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(menu, -1);
    }
}

