/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.view.bookmark.BookmarkNode;
import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ConnectAction
extends SelectionListenerAction {
    private IViewPart view;
    private ConnectionUtil connectionUtil;
    static /* synthetic */ Class class$0;

    public ConnectAction(IViewPart view) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ConnectAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(String.valueOf(clazz.getName()) + ".text"));
        this.connectionUtil = new ConnectionUtil();
        this.view = view;
        this.setImageDescriptor(ImageStore.getImageDescriptor("connect"));
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
        this.view = view;
    }

    public void run() {
        int bookmarks = 0;
        int errors = 0;
        String lastBookmarkName = null;
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            Bookmark bookmark = ((BookmarkNode)i.next()).getBookmark();
            Connection connection = this.connectionUtil.connect(bookmark, this.getShell());
            if (connection == null) {
                ++errors;
            }
            ++bookmarks;
            lastBookmarkName = bookmark.getName();
        }
        if (bookmarks == 1 && errors == 0) {
            this.updateStatusLine(this.getMessage("singleSuccessMessage", new Object[]{lastBookmarkName}));
        } else if (bookmarks == 1 && errors == 1) {
            this.updateStatusLine(this.getMessage("singleFailureMessage", new Object[]{lastBookmarkName}));
        } else if (bookmarks > 1 && errors == 0) {
            this.updateStatusLine(this.getMessage("multiSuccessMessage", new Object[]{String.valueOf(bookmarks)}));
        } else if (bookmarks > 1 && errors > 0) {
            this.updateStatusLine(this.getMessage("multiFailureMessage", new Object[]{String.valueOf(bookmarks - errors), String.valueOf(errors)}));
        }
    }

    private String getMessage(String key, Object[] arguments) {
        return Messages.getString(String.valueOf(((Object)((Object)this)).getClass().getName()) + "." + key, arguments);
    }

    protected void updateStatusLine(String message) {
        this.view.getViewSite().getActionBars().getStatusLineManager().setMessage(message);
    }

    protected Shell getShell() {
        return this.view.getSite().getShell();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = super.updateSelection(selection);
        Iterator i = selection.iterator();
        while (enabled && i.hasNext()) {
            Object object = i.next();
            if (object instanceof BookmarkNode) {
                BookmarkNode node = (BookmarkNode)object;
                enabled &= !node.getBookmark().isConnected();
                continue;
            }
            enabled = false;
        }
        return enabled;
    }
}

