/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.actions.BaseExecuteAction;
import com.quantum.actions.BookmarkAction;
import com.quantum.actions.BookmarkSelectionUtil;
import com.quantum.actions.BookmarkSubActionFactory;
import com.quantum.model.Bookmark;
import com.quantum.sql.parser.SQLParser;
import com.quantum.sql.parser.SQLProvider;
import com.quantum.view.SQLQueryView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;

public class ExecuteAction
extends BaseExecuteAction
implements IMenuCreator,
BookmarkAction,
PropertyChangeListener {
    private boolean autoCommit = true;
    private boolean canChangeAutoCommit = true;
    private final SQLProvider sqlProvider;
    private final IWorkbenchPartSite site;
    private final IActionBars actionBars;
    private final SQLQueryView view;
    static /* synthetic */ Class class$0;

    public ExecuteAction(SQLProvider sqlProvider, SQLQueryView view) {
        this(sqlProvider, view.getViewSite().getActionBars(), view.getSite(), view);
    }

    public ExecuteAction(SQLProvider sqlProvider, IEditorPart editor) {
        this(sqlProvider, editor.getEditorSite().getActionBars(), editor.getSite(), null);
        this.canChangeAutoCommit = false;
    }

    private ExecuteAction(SQLProvider sqlProvider, IActionBars actionBars, IWorkbenchPartSite site, SQLQueryView view) {
        this.sqlProvider = sqlProvider;
        this.actionBars = actionBars;
        this.site = site;
        this.view = view;
        this.setActionDefinitionId("com.quantum.actions.ExecuteAction");
        this.setImageDescriptor(ImageStore.getImageDescriptor("play"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setText(Messages.getString(clazz, "textNoBookmark"));
        this.initTextAndToolTip();
        this.setMenuCreator(this);
        BookmarkSelectionUtil.getInstance().addPropertyChangeListener(this);
    }

    private void initTextAndToolTip() {
        Bookmark lastUsedBookmark = BookmarkSelectionUtil.getInstance().getLastUsedBookmark();
        if (lastUsedBookmark == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.actions.ExecuteAction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setToolTipText(Messages.getString(clazz, "textNoBookmark"));
        } else {
            Object[] parameters = new Object[]{lastUsedBookmark.getName()};
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.actions.ExecuteAction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setToolTipText(Messages.getString(clazz, "text", parameters));
        }
    }

    protected Bookmark getBookmark() {
        Bookmark lastUsedBookmark = BookmarkSelectionUtil.getInstance().getLastUsedBookmark();
        return lastUsedBookmark == null ? super.getBookmark() : lastUsedBookmark;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(Bookmark bookmark, Connection connection) throws IOException, CoreException, SQLException {
        try {
            boolean changed = false;
            if (this.view != null) {
                this.autoCommit = this.view.isAutoCommit();
            }
            if (!bookmark.isIgnoreQueryViewSetting() && this.canChangeAutoCommit && connection.getAutoCommit() != this.autoCommit) {
                connection.setAutoCommit(this.autoCommit);
                changed = true;
            }
            super.execute(bookmark, connection);
            if (changed) {
                Shell shell = this.getShell();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("com.quantum.actions.ExecuteAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                String string = Messages.getString(clazz, "autocommitTitle");
                Class<?> clazz3 = class$0;
                if (clazz3 == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("com.quantum.actions.ExecuteAction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz3 = class$0 = clazz4;
                }
                MessageDialog.openInformation((Shell)shell, (String)string, (String)Messages.getString(clazz3, "autocommitMessage", new Object[]{bookmark.getName()}));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            BookmarkSelectionUtil.getInstance().setLastUsedBookmark(bookmark);
            throw throwable;
        }
        {
            Object var4_6 = null;
            BookmarkSelectionUtil.getInstance().setLastUsedBookmark(bookmark);
            return;
        }
    }

    protected List getQueries() {
        IStatusLineManager iStatusLineManager = this.getStatusLineManager();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ExecuteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iStatusLineManager.setMessage(Messages.getString(clazz, "parsing"));
        Vector queries = SQLParser.parse(this.sqlProvider.getQuery());
        return queries;
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.actionBars.getStatusLineManager();
    }

    protected Shell getShell() {
        return this.site.getShell();
    }

    public void dispose() {
        BookmarkSelectionUtil.getInstance().removePropertyChangeListener(this);
    }

    public Menu getMenu(Control parent) {
        return BookmarkSubActionFactory.populateDropDownMenu(this, new Menu(parent));
    }

    public Menu getMenu(Menu parent) {
        return BookmarkSubActionFactory.populateDropDownMenu(this, new Menu(parent));
    }

    public boolean isEnabled(Bookmark bookmark) {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("lastUsedBookmark".equals(event.getPropertyName())) {
            this.initTextAndToolTip();
        }
    }
}

