/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.log.QuantumLog;
import com.quantum.view.SQLQueryView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class ImportQueryAction
extends Action
implements IViewActionDelegate {
    SQLQueryView view;
    FileDialog dialog;

    public ImportQueryAction() {
        this.setText(Messages.getString("sqlqueryview.importQuery"));
        this.setImageDescriptor(ImageStore.getImageDescriptor("import"));
        this.setToolTipText(Messages.getString("sqlqueryview.importQuery"));
    }

    public void init(IViewPart view) {
        this.view = (SQLQueryView)view;
        this.dialog = new FileDialog(view.getSite().getShell(), 4096);
        this.dialog.setFilterExtensions(new String[]{"*.sql", "*.ddl", "*.*"});
        this.dialog.setFilterNames(new String[]{Messages.getString("filedialog.sqlFiles"), Messages.getString("filedialog.ddlFiles"), Messages.getString("filedialog.allfiles")});
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        this.dialog.setFilterPath(QuantumPlugin.getDefault().getPreferenceStore().getString("quantum.dialogs.importquery.path"));
        String filename = this.dialog.open();
        if (filename != null) {
            QuantumPlugin.getDefault().getPreferenceStore().setValue("quantum.dialogs.importquery.path", filename);
            try {
                String line;
                File importFile = new File(filename);
                FileReader fileReader = new FileReader(importFile);
                BufferedReader reader = new BufferedReader(fileReader);
                StringBuffer buffer = new StringBuffer();
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                this.view.setQuery(buffer.toString());
                reader.close();
            }
            catch (IOException e) {
                QuantumLog.getInstance().error("Problem importing query", e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

