/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.search.SearchResults;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLStandardResultSetResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.ui.dialog.SearchDialog;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.bookmark.QueryListNode;
import com.quantum.view.bookmark.QuickListNode;
import com.quantum.view.bookmark.SchemaNode;
import com.quantum.view.bookmark.TreeNode;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class SearchEntityAction
extends SelectionListenerAction {
    private IViewPart view;
    private ConnectionUtil connectionUtil;
    private boolean searchString;
    private boolean findSubString;
    private boolean exactly;
    private String toSearch;
    private String numberToSearch;
    private int nItems;
    static /* synthetic */ Class class$0;

    public SearchEntityAction(IViewPart view) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.SearchEntityAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(clazz, "text"));
        this.connectionUtil = new ConnectionUtil();
        this.setImageDescriptor(ImageStore.getImageDescriptor("search_results_view"));
        this.view = view;
    }

    public void run() {
        final List list = this.getSelectedNonResources();
        Entity entity = null;
        if (list.size() < 1) {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"You have selected nothing");
            return;
        }
        Object selection = list.get(0);
        String iconName = null;
        if (selection instanceof QuickListNode) {
            iconName = "group";
        } else if (selection instanceof GroupNode) {
            iconName = "entitygroup";
        } else if (selection instanceof SchemaNode) {
            iconName = "schema";
        } else if (selection instanceof EntityNode) {
            entity = ((EntityNode)list.get(0)).getEntity();
            if ("VIEW".equals(entity.getType())) {
                iconName = "view";
            } else if ("TABLE".equals(entity.getType())) {
                iconName = "bigtable";
            } else if (entity.isSynonym()) {
                iconName = "big_syn_table";
            }
        } else if (selection instanceof QueryListNode) {
            iconName = "group";
        } else {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Unsupported action", (String)"Search is unavailable for this selection");
            return;
        }
        SearchDialog sd = new SearchDialog(this.view.getSite().getShell(), iconName);
        int result = sd.open();
        if (result == 0) {
            this.toSearch = sd.getText();
            this.searchString = this.toSearch != "";
            this.exactly = sd.getMatchCase();
            if (!this.exactly) {
                this.toSearch = this.toSearch.toLowerCase();
            }
            this.findSubString = sd.getFindSubString();
            this.numberToSearch = sd.getNumber();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
            this.nItems = 0;
            SearchResults.getInstance().addToResults("Search", "Search for:" + (this.searchString ? String.valueOf(this.toSearch) + ";" + (this.exactly ? "true;" : "false;") + (this.findSubString ? "true;" : "false;") : this.numberToSearch));
            try {
                dialog.run(false, true, new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        SearchEntityAction.this.nItems = SearchEntityAction.this.getListItems(list);
                        monitor.beginTask("Searching...", SearchEntityAction.this.nItems);
                        try {
                            try {
                                SearchEntityAction.this.handleList(list, monitor);
                            }
                            catch (NotConnectedException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e);
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_6 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var3_7 = null;
                        }
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                page.showView("com.quantum.view.sqlsearchresultstree");
            }
            catch (PartInitException partInitException) {}
        }
    }

    private void handleEntity(Entity entity) {
        Connection connection = this.connectionUtil.getConnection(entity.getBookmark(), this.getShell());
        if (connection != null) {
            try {
                SQLResultSetResults.Row[] rows = MultiSQLServer.getInstance().getMetaData(entity, connection).getRows();
                if (rows != null) {
                    String select = "SELECT * ";
                    String query = this.makeQuery(rows, entity);
                    if (!query.endsWith(" WHERE ")) {
                        SQLStandardResultSetResults results = (SQLStandardResultSetResults)MultiSQLServer.getInstance().execute((Connectable)entity.getBookmark(), connection, entity, String.valueOf(select) + query);
                        this.addToSearchResults(results, rows, connection);
                    }
                }
            }
            catch (SQLException e) {
                SQLExceptionDialog.openException(this.getShell(), entity == null ? null : entity.getBookmark(), e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected Shell getShell() {
        return this.view.getViewSite().getShell();
    }

    private String makeQuery(SQLResultSetResults.Row[] rows, Entity entity) {
        String query = " FROM " + entity.getQuotedTableName() + " WHERE ";
        int i = 0;
        while (i < rows.length) {
            query = String.valueOf(query) + this.addToClause((String)rows[i].get(1), (Integer)rows[i].get(7), entity);
            ++i;
        }
        if (query.endsWith(" OR ")) {
            query = query.substring(0, query.length() - 4);
        }
        return query;
    }

    private String addToClause(String columnName, Integer type, Entity entity) {
        int iType = type;
        String clause = "";
        columnName = entity.getBookmark().filterQuoteName(columnName);
        if (this.searchString) {
            if (iType == 12 || iType == -1) {
                clause = this.findSubString ? (this.exactly || iType == -1 ? "(" + columnName + " LIKE " + entity.getBookmark().getAdapter().quote("%" + this.toSearch + "%", 12, "") + ") OR " : "(LOWER(" + columnName + ") LIKE " + entity.getBookmark().getAdapter().quote("%" + this.toSearch + "%", 12, "") + ") OR ") : (this.exactly || iType == -1 ? "(" + columnName + "=" + entity.getBookmark().getAdapter().quote(this.toSearch, 12, "") + ") OR " : "(LOWER(" + columnName + ")=" + entity.getBookmark().getAdapter().quote(this.toSearch, 12, "") + ") OR ");
            }
        } else if (iType == 2 || iType == -5 || iType == 3 || iType == 8 || iType == 6 || iType == 4 || iType == 7 || iType == 5 || iType == -6) {
            clause = "(" + columnName + "=" + this.numberToSearch + ") OR ";
        }
        return clause;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return true;
    }

    private void handleList(List list, IProgressMonitor pm) throws NotConnectedException, SQLException, InterruptedException {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof DbObjectNode) {
                Entity entity = ((EntityNode)object).getEntity();
                pm.subTask(entity.getName());
                this.handleEntity(entity);
                if (pm.isCanceled()) {
                    throw new InterruptedException();
                }
                pm.worked(1);
                continue;
            }
            if (!(object instanceof GroupNode) && !(object instanceof SchemaNode) && !(object instanceof QuickListNode)) continue;
            TreeNode groupNode = (TreeNode)object;
            Object[] children = groupNode.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof DbObjectNode) {
                    Entity entity = ((EntityNode)children[i]).getEntity();
                    pm.subTask(entity.getName());
                    this.handleEntity(entity);
                    if (pm.isCanceled()) {
                        throw new InterruptedException();
                    }
                    pm.worked(1);
                } else if (children[i] instanceof GroupNode) {
                    this.handleList(Arrays.asList((GroupNode)children[i]), pm);
                }
                ++i;
            }
        }
    }

    private int getListItems(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof DbObjectNode) {
                ++this.nItems;
                continue;
            }
            if (!(object instanceof GroupNode) && !(object instanceof SchemaNode) && !(object instanceof QuickListNode)) continue;
            TreeNode groupNode = (TreeNode)object;
            try {
                Object[] children = groupNode.getChildren();
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof DbObjectNode) {
                        ++this.nItems;
                    } else if (children[i] instanceof GroupNode) {
                        this.getListItems(Arrays.asList((GroupNode)children[i]));
                    }
                    ++i;
                }
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (SQLException sQLException) {}
        }
        return this.nItems;
    }

    private void addToSearchResults(SQLStandardResultSetResults results, SQLResultSetResults.Row[] rows, Connection connection) {
        if (results != null && results.isResultSet()) {
            boolean ok = true;
            while (ok) {
                int nCols = results.getColumnCount();
                int nRows = results.getRowCount();
                int i = 0;
                while (i < nRows) {
                    int j = 0;
                    while (j < nCols) {
                        String primaryKey;
                        String value = results.getElement(j + 1, i + 1).toString();
                        Integer type = (Integer)rows[j].get(7);
                        int iType = type;
                        if (this.searchString) {
                            if (iType == 12 || iType == -1) {
                                if (!this.exactly) {
                                    value = value.toLowerCase();
                                }
                                if (this.findSubString) {
                                    if (value.indexOf(this.toSearch) != -1) {
                                        primaryKey = this.getPrimaryKey(results, i + 1);
                                        SearchResults.getInstance().addToResults(results.getEntity().getQualifiedName(), results.getColumnName(j + 1), value, primaryKey);
                                    }
                                } else if (value.equals(this.toSearch)) {
                                    primaryKey = this.getPrimaryKey(results, i + 1);
                                    SearchResults.getInstance().addToResults(results.getEntity().getQualifiedName(), results.getColumnName(j + 1), value, primaryKey);
                                }
                            }
                        } else if ((iType == 2 || iType == -5 || iType == 3 || iType == 8 || iType == 6 || iType == 4 || iType == 7 || iType == 5 || iType == -6) && value.equals(this.numberToSearch)) {
                            primaryKey = this.getPrimaryKey(results, i + 1);
                            SearchResults.getInstance().addToResults(results.getEntity().getQualifiedName(), results.getColumnName(j + 1), value, primaryKey);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (results.hasMore()) {
                    try {
                        results.nextPage(connection);
                        ok = true;
                    }
                    catch (SQLException sQLException) {
                        ok = false;
                    }
                    continue;
                }
                ok = false;
            }
        }
    }

    private String getPrimaryKey(SQLStandardResultSetResults results, int row) {
        String PK = "";
        try {
            Column[] pks = results.getEntity().getPrimaryKeyColumns();
            if (pks.length != 0) {
                int i = 0;
                while (i < pks.length) {
                    PK = String.valueOf(PK) + pks[i].getName() + ":" + results.getElement(pks[i].getPosition(), row).toString() + ",";
                    ++i;
                }
                if (PK.endsWith(",")) {
                    PK = PK.substring(0, PK.length() - 1);
                }
            }
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (SQLException sQLException) {
        }
        catch (Exception exception) {}
        PK = "{" + PK + "}";
        return PK;
    }
}

