/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.actions.BookmarkSelectionUtil;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Schema;
import com.quantum.model.xml.XMLMetadataIterator;
import com.quantum.model.xml.XMLToModelConverter;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLHelper;
import com.quantum.view.SQLQueryView;
import com.quantum.view.bookmark.BookmarkNode;
import com.quantum.view.bookmark.SchemaNode;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StructurePasteAction
extends SelectionListenerAction {
    private final IViewPart view;
    static /* synthetic */ Class class$0;

    public StructurePasteAction(IViewPart view) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.StructurePasteAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(clazz, "text"));
        this.view = view;
        this.setImageDescriptor(ImageStore.getImageDescriptor("paste"));
    }

    public void run() {
        List list = this.getSelectedNonResources();
        if (list.size() != 1) {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"Please select just one schema or bookmark");
            return;
        }
        Object selection = list.get(0);
        if (selection instanceof BookmarkNode || selection instanceof SchemaNode) {
            Element root;
            Document doc;
            try {
                doc = XMLHelper.getDocumentFromClipboard();
            }
            catch (Exception exception) {
                MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"Clipboard contents doesn't seem to be XML. Try Structure->Copy on a table");
                return;
            }
            Element element = root = doc == null ? null : doc.getDocumentElement();
            if (root == null || !root.getNodeName().equals(Messages.getString("ExportXMLAction.Metadata"))) {
                MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"Clipboard contents doesn't seem to be Quantum metadata. Try Structure->Copy on a table");
                return;
            }
            SchemaNode schemaNode = (SchemaNode)selection;
            String createEntities = "";
            XMLMetadataIterator iter = new XMLMetadataIterator(doc, 1);
            Bookmark bookmark = schemaNode.getBookmark();
            Shell shell = this.view.getSite().getShell();
            String eol = System.getProperty("line.separator");
            if (!bookmark.isConnected()) {
                new ConnectionUtil().connect(bookmark, shell);
            }
            while (iter.hasNext()) {
                Element element2 = (Element)iter.next();
                String database = element2.getAttribute("database");
                try {
                    boolean useJavaTypes = !database.equals(bookmark.getAdapter().getDisplayName());
                    createEntities = String.valueOf(createEntities) + this.buidCreateStatement(bookmark, element2, schemaNode.getSchema(), useJavaTypes);
                    createEntities = String.valueOf(createEntities) + eol;
                }
                catch (NotConnectedException e2) {
                    e2.printStackTrace();
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
            SQLQueryView queryView = SQLQueryView.getInstance();
            BookmarkSelectionUtil.getInstance().setLastUsedBookmark(bookmark);
            if (queryView != null && createEntities != null) {
                queryView.setQuery(createEntities);
            }
        } else {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"Your selection cannot be pasted. Try selecting a schema or bookmark");
            return;
        }
    }

    private String buidCreateStatement(Bookmark bookmark, Node node, Schema schema, boolean useJavaTypes) throws NotConnectedException, SQLException {
        DatabaseAdapter adapter = bookmark.getAdapter();
        if (node.getNodeName() == "table") {
            XMLToModelConverter tableMetadata = new XMLToModelConverter((Element)node);
            return adapter.buildCreateTable(bookmark, tableMetadata, schema, useJavaTypes);
        }
        if (node.getNodeName() == "view") {
            XMLToModelConverter tableMetadata = new XMLToModelConverter((Element)node);
            return adapter.buildCreateView(bookmark, tableMetadata, schema);
        }
        if (node.getNodeName() == "sequence") {
            XMLToModelConverter sequenceMetadata = new XMLToModelConverter((Element)node);
            return adapter.buildCreateSequence(bookmark, sequenceMetadata, schema);
        }
        return "";
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

