/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Entity;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.Connectable;
import com.quantum.view.bookmark.EntityNode;
import java.sql.SQLException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ViewTableAction
extends SelectionListenerAction {
    private Entity entity;
    private ConnectionUtil connectionUtil;
    private final IViewPart view;
    static /* synthetic */ Class class$0;

    public ViewTableAction(IViewPart view) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ViewTableAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(clazz, "text"));
        this.connectionUtil = new ConnectionUtil();
        this.view = view;
        this.setImageDescriptor(ImageStore.getImageDescriptor("table"));
    }

    public void run() {
        Bookmark bookmark = this.entity.getBookmark();
        DatabaseAdapter adapter = bookmark.getAdapter();
        String query = adapter.getTableQuery(this.entity.getQuotedTableName());
        try {
            SQLResults results = MultiSQLServer.getInstance().execute((Connectable)bookmark, this.connectionUtil.connect(bookmark, this.getShell()), this.entity, query);
            if (results != null && results.isResultSet()) {
                SQLResultSetCollection.getInstance().addSQLResultSet((SQLResultSetResults)results);
            }
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.getShell(), bookmark, e);
        }
    }

    private Shell getShell() {
        return this.view.getSite().getShell();
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object object;
        boolean enabled = super.updateSelection(selection);
        if ((enabled &= selection.size() == 1) && (object = selection.getFirstElement()) != null && object instanceof EntityNode) {
            EntityNode entityNode = (EntityNode)object;
            this.entity = entityNode.getEntity();
            enabled &= entityNode.isTable() || entityNode.isView();
        }
        return enabled;
    }
}

