/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.adapters.OracleStatementExplainer;
import com.quantum.adapters.StatementExplainer;
import com.quantum.model.Bookmark;
import com.quantum.model.Check;
import com.quantum.model.Column;
import com.quantum.model.DataType;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.Schema;
import com.quantum.model.SequenceMetadata;
import com.quantum.model.TableMetadata;
import com.quantum.model.Trigger;
import com.quantum.util.QuantumUtil;
import com.quantum.util.StringMatrix;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.sql.TypesHelper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;

public class OracleAdapter
extends DatabaseAdapter {
    private OracleStatementExplainer explainer = new OracleStatementExplainer();

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("getComments")) {
            properties.put("remarksReporting", "true");
        }
        if (store.getBoolean("getSynonyms")) {
            properties.put("includeSynonyms", "true");
        }
        return properties;
    }

    protected OracleAdapter() {
        super("ORACLE");
    }

    public String getShowSequenceQuery(String qualifier) {
        return "SELECT SEQUENCE_OWNER, SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '" + qualifier + "'";
    }

    public String getPrevValue(String sequence, String owner) {
        return "SELECT " + this.getQualifiedName(owner, sequence) + ".CURRVAL FROM DUAL";
    }

    public String getNextValue(String sequence, String owner) {
        return "SELECT " + this.getQualifiedName(owner, sequence) + ".NEXTVAL FROM DUAL";
    }

    public String getRemarksQuery(String tableName, String column) {
        String query = "SELECT COMMENTS FROM ALL_COL_COMMENTS WHERE TABLE_NAME = '";
        query = String.valueOf(query) + QuantumUtil.getTableName(tableName) + "' AND COLUMN_NAME = '" + column + "'";
        if (!QuantumUtil.getSchemaName(tableName).equals("")) {
            query = String.valueOf(query) + " AND OWNER = '" + QuantumUtil.getSchemaName(tableName) + "'";
        }
        return query;
    }

    public String quote(String string, int type, String typeString) {
        if (type == 91 || type == 93) {
            String sub;
            if ((string = string.trim()).length() > 1 && (sub = string.substring(string.length() - 2, string.length() - 1)).equals(Messages.getString("."))) {
                string = string.substring(0, string.length() - 2);
            }
            return "TO_DATE('" + string + "','yyyy-mm-dd hh24:mi:ss')";
        }
        return super.quote(string, type, typeString);
    }

    public String getDefaultSchema(String userid) {
        return super.getDefaultSchema(userid).toUpperCase();
    }

    public Map getDefaultConnectionParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "1521");
        map.put("hostname", "localhost");
        return map;
    }

    public String getShowSynonymsQuery(String schema, String type) {
        return "select SYNONYM_NAME from ALL_SYNONYMS, ALL_OBJECTS where  ALL_SYNONYMS.OWNER = '" + schema + "'" + " and ALL_SYNONYMS.TABLE_OWNER = ALL_OBJECTS.OWNER" + " and ALL_SYNONYMS.TABLE_NAME = ALL_OBJECTS.OBJECT_NAME" + " and ALL_OBJECTS.OBJECT_TYPE = '" + type + "'";
    }

    public String getShowPackagesQuery(String userid) {
        return "select OBJECT_NAME from ALL_OBJECTS where OBJECT_TYPE = 'PACKAGE' and OWNER='" + this.getDefaultSchema(userid) + "'";
    }

    public String getProceduresQuery(String schema, String pack) {
        return "select distinct OBJECT_NAME, nvl( OVERLOAD, 0 ) from ALL_ARGUMENTS where OWNER='" + schema.toUpperCase() + "' " + (pack == null ? "" : "and PACKAGE_NAME = '" + pack.toUpperCase() + "'");
    }

    public String getProcedureArgumentsQuery(String schema, String pack, String proc, int overload) {
        return "select ARGUMENT_NAME, POSITION, DATA_TYPE from ALL_ARGUMENTS where OWNER='" + schema.toUpperCase() + "' " + "and OBJECT_NAME='" + proc.toUpperCase() + "' " + "and nvl( OVERLOAD,0)=" + overload + " " + (pack == null ? "" : "and PACKAGE_NAME = '" + pack.toUpperCase() + "'");
    }

    public String getCreateStatement(String schema, String viewName) {
        return "select TEXT from ALL_VIEWS where OWNER = '" + schema + "'" + "and VIEW_NAME = '" + viewName + "'";
    }

    public String getSequenceMetadataQuery(String schema, String sequenceName) {
        return "select MIN_VALUE, MAX_VALUE, LAST_NUMBER, INCREMENT_BY, decode(CYCLE_FLAG, 'N', 'FALSE', 'Y', 'TRUE' , 'FALSE'), decode(ORDER_FLAG, 'N', 'FALSE', 'Y', 'TRUE' , 'FALSE')from ALL_SEQUENCES where SEQUENCE_OWNER = '" + schema + "'" + "and SEQUENCE_NAME = '" + sequenceName + "'";
    }

    public String getTriggersStatement(String schema, String name) {
        return "select TRIGGER_NAME, decode( substr( trigger_type, 1, 1 ), 'A', 'AFTER', 'B', 'BEFORE', 'I', 'INSTEAD OF', null ),decode( instr( trigger_type, 'EACH ROW' ), 0, null, 'FOR EACH ROW' ),TRIGGERING_EVENT, COLUMN_NAME, NULL, REFERENCING_NAMES, WHEN_CLAUSE, STATUS, ACTION_TYPE, TRIGGER_BODY from ALL_TRIGGERS where TABLE_OWNER = '" + schema + "'" + "and TABLE_NAME = '" + name + "'";
    }

    public String getChecksStatement(String schema, String objectName) {
        return "select CONSTRAINT_NAME, SEARCH_CONDITION from ALL_CONSTRAINTS where OWNER = '" + schema + "'" + "and TABLE_NAME = '" + objectName + "'" + "and CONSTRAINT_TYPE = 'C'";
    }

    public String buildCreateTable(Bookmark bookmark, TableMetadata metadata, Schema schema, boolean useJavaTypes) throws NotConnectedException, SQLException {
        return super.buildCreateTable(bookmark, metadata, schema, useJavaTypes);
    }

    public String buildRemarks(Bookmark bookmark, String tableName, TableMetadata metadata) throws NotConnectedException, SQLException {
        Column[] columns = metadata.getColumns();
        if (columns == null || columns.length == 0) {
            return "";
        }
        String eol = System.getProperty("line.separator");
        String comments = "";
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (column.getRemarks() != null && column.getRemarks() != "") {
                comments = String.valueOf(comments) + "COMMENT ON COLUMN " + bookmark.filterQuoteName(tableName) + "." + bookmark.filterQuoteName(column.getName()) + " IS '" + column.getRemarks() + "';" + eol;
            }
            ++i;
        }
        return comments;
    }

    public String buildTriggers(Bookmark bookmark, String tableName, TableMetadata metadata, Schema schema) {
        Trigger[] triggers = null;
        String createTriggers = "";
        String eol = System.getProperty("line.separator");
        try {
            triggers = metadata.getTriggers();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (triggers != null) {
            int i = 0;
            while (i < triggers.length) {
                Trigger trigger = triggers[i];
                createTriggers = String.valueOf(createTriggers) + "CREATE TRIGGER " + QuantumUtil.getQualifiedName(schema.getName(), trigger.getName()) + eol;
                createTriggers = String.valueOf(createTriggers) + trigger.getMoment() + " " + trigger.getEvent() + eol;
                createTriggers = String.valueOf(createTriggers) + " ON " + bookmark.filterQuoteName(tableName) + eol;
                createTriggers = String.valueOf(createTriggers) + trigger.getReferencing() + eol;
                if (trigger.getForEach() != null) {
                    createTriggers = String.valueOf(createTriggers) + trigger.getForEach();
                    createTriggers = String.valueOf(createTriggers) + (trigger.getWhenClause() != null ? trigger.getWhenClause() : "");
                    createTriggers = String.valueOf(createTriggers) + eol;
                }
                createTriggers = String.valueOf(createTriggers) + trigger.getBody() + ";" + eol;
                ++i;
            }
        }
        return createTriggers;
    }

    public String buildChecks(Bookmark bookmark, String tableName, TableMetadata metadata, Schema schema) {
        Check[] checks = null;
        String createTriggers = "";
        String eol = System.getProperty("line.separator");
        try {
            checks = metadata.getChecks();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (checks != null) {
            int i = 0;
            while (i < checks.length) {
                Check check = checks[i];
                createTriggers = String.valueOf(createTriggers) + "ALTER TABLE " + bookmark.filterQuoteName(tableName) + eol;
                createTriggers = String.valueOf(createTriggers) + " ADD CONSTRAINT " + check.getName() + eol;
                createTriggers = String.valueOf(createTriggers) + " CHECK (" + check.getBody() + ");" + eol;
                ++i;
            }
        }
        return createTriggers;
    }

    public String buildPrimaryKey(Bookmark bookmark, String tableName, TableMetadata metadata) throws NotConnectedException, SQLException {
        Column[] columns = metadata.getPrimaryKeyColumns();
        if (columns == null || columns.length == 0) {
            return "";
        }
        String eol = System.getProperty("line.separator");
        String primaryKey = "ALTER TABLE " + bookmark.filterQuoteName(tableName) + eol + "   ADD CONSTRAINT " + QuantumUtil.getTableName(tableName) + "_PK PRIMARY KEY ( ";
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            if (i > 0) {
                primaryKey = String.valueOf(primaryKey) + ", ";
            }
            primaryKey = String.valueOf(primaryKey) + column.getName();
            ++i;
        }
        primaryKey = String.valueOf(primaryKey) + " );" + eol;
        return primaryKey;
    }

    public String buildForeignKeys(Bookmark bookmark, TableMetadata metadata, Schema schema, boolean absoluteReference) throws NotConnectedException, SQLException {
        ForeignKey[] keys = metadata.getImportedKeys();
        if (keys == null || keys.length == 0) {
            return "";
        }
        String foreignKey = "";
        String eol = System.getProperty("line.separator");
        int i = 0;
        while (i < keys.length) {
            ForeignKey key = keys[i];
            String localTableName = QuantumUtil.getQualifiedName(schema.getName(), key.getLocalEntityName());
            String foreignSchemaName = key.getForeignEntitySchema();
            if (!absoluteReference && key.getLocalEntitySchema().equals(key.getForeignEntitySchema())) {
                foreignSchemaName = schema.getName();
            }
            String foreignTableName = QuantumUtil.getQualifiedName(foreignSchemaName, key.getForeignEntityName());
            QuantumUtil.getQualifiedName(schema.getName(), key.getLocalEntityName());
            foreignKey = String.valueOf(foreignKey) + "ALTER TABLE " + bookmark.filterQuoteName(foreignTableName) + eol + "   ADD CONSTRAINT " + key.getName() + " FOREIGN KEY ( ";
            int j = 0;
            while (j < key.getNumberOfColumns()) {
                if (j > 0) {
                    foreignKey = String.valueOf(foreignKey) + ", ";
                }
                foreignKey = String.valueOf(foreignKey) + key.getForeignColumnName(j);
                ++j;
            }
            foreignKey = String.valueOf(foreignKey) + " )" + eol;
            foreignKey = String.valueOf(foreignKey) + "   REFERENCES " + localTableName + "( ";
            j = 0;
            while (j < key.getNumberOfColumns()) {
                if (j > 0) {
                    foreignKey = String.valueOf(foreignKey) + ", ";
                }
                foreignKey = String.valueOf(foreignKey) + key.getLocalColumnName(j);
                ++j;
            }
            foreignKey = String.valueOf(foreignKey) + " );" + eol;
            ++i;
        }
        return foreignKey;
    }

    public String buildCreateSequence(Bookmark bookmark, SequenceMetadata metadata, Schema schema) throws NotConnectedException, SQLException {
        String eol = System.getProperty("line.separator");
        String sequenceName = QuantumUtil.getQualifiedName(schema.getName(), metadata.getName());
        String createSequence = "CREATE SEQUENCE " + bookmark.filterQuoteName(sequenceName) + eol;
        createSequence = String.valueOf(createSequence) + "MINVALUE " + metadata.getMinValue() + eol;
        createSequence = String.valueOf(createSequence) + "MAXVALUE " + metadata.getMaxValue() + eol;
        createSequence = String.valueOf(createSequence) + "START WITH " + metadata.getInitialValue() + eol;
        createSequence = String.valueOf(createSequence) + "INCREMENT BY " + metadata.getIncrementBy();
        if (metadata.isCycled()) {
            createSequence = String.valueOf(createSequence) + eol + "CYCLE";
        }
        if (metadata.isOrdered()) {
            createSequence = String.valueOf(createSequence) + eol + "ORDERED";
        }
        return createSequence;
    }

    public String buildCreateView(Bookmark bookmark, TableMetadata metadata, Schema schema) throws NotConnectedException, SQLException {
        String eol = System.getProperty("line.separator");
        String metadataCreate = metadata.getCreateStatement();
        if (metadataCreate == null) {
            return "";
        }
        if (metadataCreate.length() > 6 && metadataCreate.trim().substring(0, 6).toUpperCase().equals("CREATE")) {
            return metadataCreate;
        }
        String viewName = QuantumUtil.getQualifiedName(schema.getName(), metadata.getName());
        return "CREATE VIEW " + bookmark.filterQuoteName(viewName) + eol + "  AS " + eol + metadataCreate;
    }

    public String getWhereClause(Entity entity, StringMatrix key, int iRow) {
        StringBuffer whereClause = new StringBuffer();
        Bookmark bookmark = entity.getBookmark();
        int iKey = 0;
        while (iKey < key.getNumColumns()) {
            if (iKey > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("(");
            String column = key.getHeaderColumn(iKey);
            whereClause.append(bookmark != null ? bookmark.filterQuoteName(column) : column);
            whereClause.append(" = ");
            whereClause.append(this.quoteValue(entity, key.getHeaderColumn(iKey), key.get(iKey, iRow)));
            whereClause.append(")");
            ++iKey;
        }
        return whereClause.toString();
    }

    public StatementExplainer getStatementExplainer() {
        return this.explainer;
    }

    public String javaToSQL(DataType[] types, int javaType) {
        if (javaType == 3 || javaType == TypesHelper.BOOLEAN) {
            javaType = 2;
        }
        return super.javaToSQL(types, javaType);
    }

    public String getTypeName(Bookmark bookmark, Column column, boolean useJavaTypes) {
        if (useJavaTypes && column.getType() == 93) {
            return "TIMESTAMP";
        }
        String result = super.getTypeName(bookmark, column, useJavaTypes).toUpperCase();
        result = result.replaceAll("TIME ZONE\\([^)]*\\)", "TIME ZONE");
        result = result.replaceAll("DATE\\([^)]*\\)", "DATE");
        result = result.replaceAll("TO MONTH\\([^)]*\\)", "TO MONTH");
        result = result.replaceAll("ROWID\\([^)]*\\)", "ROWID");
        result = result.replaceAll("LOB\\([^)]*\\)", "LOB");
        result = result.replaceAll("LONG\\([^)]*\\)", "LONG");
        result = result.replaceAll("LONG RAW\\([^)]*\\)", "LONG RAW");
        result = result.replaceAll("MLSLABEL\\([^)]*\\)", "MLSLABEL");
        result = result.replaceAll("BFILE\\([^)]*\\)", "BFILE");
        return result;
    }
}

