/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.extensions;

import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.extensions.IDataExtension;
import com.quantum.extensions.IMetadataExtension;
import com.quantum.extensions.IQuantumExtension;
import com.quantum.model.xml.ModelToXMLConverter;
import com.quantum.sql.TableRow;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLHelper;
import com.quantum.util.xml.XMLRenderer;
import com.quantum.util.xml.XMLUtil;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.tableview.TableView;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtensionAction
extends SelectionListenerAction {
    private IViewPart view;
    private IQuantumExtension extension;
    private TableRow tableRow;

    public ExtensionAction(IViewPart view, String label, String toolTip, IQuantumExtension extension) {
        super(label);
        this.view = view;
        this.extension = extension;
        this.setText(label);
        this.setToolTipText(toolTip);
        this.tableRow = null;
    }

    public void run() {
        if (this.extension instanceof IMetadataExtension && this.view instanceof BookmarkView) {
            this.runMetadataExtension();
        } else if (this.extension instanceof IDataExtension && this.view instanceof TableView) {
            this.runDataExtension();
        }
    }

    private void runDataExtension() {
        Document doc;
        IDataExtension dataExtension = (IDataExtension)this.extension;
        if (this.tableRow == null) {
            return;
        }
        try {
            doc = XMLHelper.createEmptyDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        Element root = (Element)doc.appendChild(doc.createElement(Messages.getString("ExportXMLAction.Metadata")));
        XMLUtil.createElementText(root, Messages.getString("ExportXMLAction.Author"), Messages.getString("ExportXMLAction.Quantum"));
        XMLUtil.createElementText(root, Messages.getString("ExportXMLAction.Version"), Messages.getString("ExportXMLAction.XMLVersionNumber"));
        ModelToXMLConverter.getInstance().convert(root, this.tableRow.getEntity());
        XMLUtil.stringMatrixToXML(this.tableRow.getRowTableData(), doc, root, "DataRow");
        dataExtension.run(doc);
    }

    private void runMetadataExtension() {
        IMetadataExtension metadataExtension = (IMetadataExtension)this.extension;
        BookmarkView bookmarkView = (BookmarkView)this.view;
        StructuredSelection selection = bookmarkView.getSelection();
        if (selection == null) {
            return;
        }
        Document doc = null;
        try {
            doc = ModelToXMLConverter.getInstance().convertList(selection.toList(), null, false);
        }
        catch (NotConnectedException e) {
            ExceptionDisplayDialog.openError(this.view.getSite().getShell(), null, null, e);
            e.printStackTrace();
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.view.getSite().getShell(), null, e);
            e.printStackTrace();
        }
        if (doc == null) {
            return;
        }
        QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{XMLRenderer.render(doc)}, new Transfer[]{TextTransfer.getInstance()});
        metadataExtension.run(doc);
    }

    public void addRowData(TableRow row) {
        this.tableRow = row;
    }
}

