/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.JDBCDriver;
import com.quantum.model.Schema;
import com.quantum.model.xml.ModelToXMLConverter;
import com.quantum.util.JarUtil;
import com.quantum.util.xml.XMLUtil;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BookmarkCollection {
    private static final String SUN_JDBC_ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    private static BookmarkCollection instance = new BookmarkCollection();
    private List bookmarks = new Vector();
    private boolean changed = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Set drivers = Collections.synchronizedSet(new HashSet());

    private BookmarkCollection() {
    }

    public static BookmarkCollection getInstance() {
        return instance;
    }

    public void load(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(file);
        props.load(in);
        in.close();
        this.fromProperties(true, props);
    }

    private void fromProperties(boolean overwrite, Properties props) {
        Vector<Bookmark> newBookmarks = new Vector<Bookmark>();
        int i = 0;
        while (true) {
            Bookmark bookmark = new Bookmark();
            String name = props.getProperty(String.valueOf(i) + ".name");
            if (name == null) break;
            bookmark.setName(name);
            bookmark.setUsername(props.getProperty(String.valueOf(i) + ".username"));
            bookmark.setPassword(props.getProperty(String.valueOf(i) + ".password"));
            bookmark.setConnect(props.getProperty(String.valueOf(i) + ".connect"));
            String schema = props.getProperty(String.valueOf(i) + ".schema");
            if (schema != null) {
                bookmark.addSchema(schema);
            }
            if (!bookmark.isEmpty()) {
                newBookmarks.add(bookmark);
            }
            String driver = props.getProperty(String.valueOf(++i) + ".driver");
            String driverFile = props.getProperty(String.valueOf(i) + ".driverLocation");
            String type = props.getProperty(String.valueOf(i) + ".type");
            this.drivers.add(new JDBCDriver(driver, new String[]{driverFile}, type));
        }
        if (overwrite) {
            this.bookmarks = newBookmarks;
        } else {
            this.bookmarks.addAll(newBookmarks);
        }
    }

    public Bookmark find(String name) {
        Bookmark result = null;
        if (name != null) {
            Iterator i = this.bookmarks.iterator();
            while (result == null && i.hasNext()) {
                Bookmark temp = (Bookmark)i.next();
                if (!name.equals(temp.getName())) continue;
                result = temp;
            }
        }
        return result;
    }

    public void exportXML(Element root) {
        System.out.println("Bookmarks: Saving to Element");
        Element bookmarkRoot = XMLUtil.createElementText(root, "bookmarks", "");
        Iterator i = this.drivers.iterator();
        while (i.hasNext()) {
            JDBCDriver driver = (JDBCDriver)i.next();
            ModelToXMLConverter.getInstance().convert(bookmarkRoot, driver);
        }
        int i2 = 0;
        while (i2 < this.bookmarks.size()) {
            Bookmark b = (Bookmark)this.bookmarks.get(i2);
            ModelToXMLConverter.getInstance().convert(bookmarkRoot, b);
            ++i2;
        }
    }

    public void importXML(Element root) {
        this.changed = true;
        System.out.println("Bookmarks: Loading from Element");
        this.importDrivers(root);
        Vector newBookmarks = this.importBookmarks(root);
        Iterator iter = newBookmarks.iterator();
        while (iter.hasNext()) {
            Bookmark bookmark = (Bookmark)iter.next();
            if (this.bookmarks.contains(bookmark)) continue;
            this.bookmarks.add(bookmark);
        }
        this.support.firePropertyChange("bookmarks", null, null);
    }

    private void importDrivers(Element root) {
        NodeList nodes = root.getElementsByTagName("jdbcDriver");
        int i = 0;
        while (i < nodes.getLength()) {
            Element driver = (Element)nodes.item(i);
            ArrayList<String> jarFileNames = new ArrayList<String>();
            String jarFileName = driver.getAttribute("jarFileName");
            if (jarFileName != null && jarFileName.trim().length() > 0) {
                jarFileNames.add(jarFileName);
            }
            NodeList jars = driver.getElementsByTagName("jar");
            int j = 0;
            while (j < jars.getLength()) {
                String fileName = ((Element)jars.item(j)).getAttribute("fileName");
                if (fileName != null && fileName.trim().length() > 0) {
                    jarFileNames.add(fileName);
                }
                ++j;
            }
            if (!this.isQuantum232Notation(driver)) {
                this.addDriver(new JDBCDriver(driver.getAttribute("className"), jarFileNames.toArray(new String[jarFileNames.size()]), driver.getAttribute("type"), driver.getAttribute("name"), driver.getAttribute("version")));
            }
            ++i;
        }
        this.addStandardDrivers();
    }

    private boolean isQuantum232Notation(Element driver) {
        return "".equals(driver.getAttribute("type"));
    }

    private void addStandardDrivers() {
        if (JarUtil.loadDriver(null, SUN_JDBC_ODBC_DRIVER) != null) {
            this.addDriver(new JDBCDriver(SUN_JDBC_ODBC_DRIVER, new String[0], "JDBC_ODBC_BRIDGE"));
        }
    }

    public void addDriver(JDBCDriver driver) {
        if (!this.drivers.contains(driver)) {
            this.drivers.add(driver);
            this.support.firePropertyChange("drivers", null, driver);
        }
    }

    private Vector importBookmarks(Element root) {
        Vector<Bookmark> newBookmarks = new Vector<Bookmark>();
        NodeList nodes = root.getElementsByTagName("bookmark");
        int i = 0;
        while (i < nodes.getLength()) {
            Bookmark bookmark = new Bookmark();
            Element column = (Element)nodes.item(i);
            String name = XMLUtil.getElementText(column, "name");
            if (name == null) break;
            bookmark.setName(name);
            XMLUtil.getElementText(column, "name");
            bookmark.setUsername(XMLUtil.getElementText(column, "username"));
            bookmark.setPassword(XMLUtil.getElementText(column, "password"));
            bookmark.setPromptForPassword(Boolean.TRUE.toString().equalsIgnoreCase(XMLUtil.getElementText(column, "prompt")));
            bookmark.setConnect(XMLUtil.getElementText(column, "connect"));
            bookmark.setAutoCommit(Boolean.TRUE.toString().equalsIgnoreCase(XMLUtil.getElementText(column, "autoCommit", "True")));
            bookmark.setQuoteAll(Boolean.TRUE.toString().equalsIgnoreCase(XMLUtil.getElementText(column, "quoteAll", "False")));
            bookmark.setAutoCommitPreference(XMLUtil.getElementText(column, "autoCommitPreference", "Always True"));
            bookmark.setIgnoreQueryViewSetting(Boolean.TRUE.toString().equalsIgnoreCase(XMLUtil.getElementText(column, "autoCommitIgnoreView", "False")));
            this.backwardCompatibility(bookmark, column);
            String driverClassName = XMLUtil.getElementText(column, "driver");
            ArrayList<String> jarFiles = new ArrayList<String>();
            NodeList driverLocations = column.getElementsByTagName("driverLocation");
            int j = 0;
            int length = driverLocations == null ? 0 : driverLocations.getLength();
            while (j < length) {
                String jarFileName = XMLUtil.extractText((Element)driverLocations.item(j), "");
                if (jarFileName != null && jarFileName.trim().length() > 0) {
                    jarFiles.add(jarFileName);
                }
                ++j;
            }
            String type = XMLUtil.getElementText(column, "type");
            bookmark.setJDBCDriver(new JDBCDriver(driverClassName, jarFiles.toArray(new String[jarFiles.size()]), type));
            NodeList children = column.getElementsByTagName("Other_Schemas");
            if (children.getLength() > 0) {
                this.importSchemas((Element)children.item(0), bookmark);
            }
            System.out.println(bookmark.toString());
            if (!bookmark.isEmpty()) {
                newBookmarks.addElement(bookmark);
            }
            this.importQuickList(bookmark, column);
            this.importQueryList(bookmark, column);
            ++i;
        }
        return newBookmarks;
    }

    private void backwardCompatibility(Bookmark bookmark, Element element) {
        NodeList children = element.getChildNodes();
        int i = 0;
        int length = children.getLength();
        while (i < length) {
            String schema;
            Node node = children.item(i);
            if (node.getNodeType() == 1 && "schema".equals(((Element)node).getTagName()) && (schema = XMLUtil.extractText(element, "")) != null && schema.trim().length() > 0) {
                bookmark.addSchema(schema);
            }
            ++i;
        }
    }

    private void importSchemas(Element otherSchemas, Bookmark bookmark) {
        ArrayList<Schema> list = new ArrayList<Schema>();
        NodeList children = otherSchemas.getChildNodes();
        int i = 0;
        int length = children.getLength();
        while (i < length) {
            Node node = children.item(i);
            if (node.getNodeType() == 1 && "schema".equalsIgnoreCase(((Element)node).getTagName())) {
                list.add(new Schema(XMLUtil.extractText((Element)node, "")));
            }
            ++i;
        }
        String schemaRule = otherSchemas.getAttribute("schemaRule");
        if ("useAll".equals(schemaRule)) {
            bookmark.setSchemaRule(1);
        } else if ("useDefault".equals(schemaRule)) {
            bookmark.setSchemaRule(2);
        } else {
            bookmark.setSchemaRule(3);
        }
        bookmark.setSchemaSelections(list.toArray(new Schema[list.size()]));
    }

    private void importQuickList(Bookmark bookmark, Element bookmarkElement) {
        NodeList quickList = bookmarkElement.getElementsByTagName("quickList");
        int j = 0;
        int length = quickList == null ? 0 : quickList.getLength();
        while (j < length) {
            Element element = (Element)quickList.item(j);
            NodeList childNodes = element.getChildNodes();
            int k = 0;
            int length2 = childNodes == null ? 0 : childNodes.getLength();
            while (k < length2) {
                if (1 == childNodes.item(k).getNodeType()) {
                    Element entity = (Element)childNodes.item(k);
                    bookmark.addQuickListEntry(entity.getTagName(), entity.getAttribute("schema"), entity.getAttribute("name"), entity.getAttribute("isSynonym").equals("true"));
                }
                ++k;
            }
            ++j;
        }
    }

    private void importQueryList(Bookmark bookmark, Element bookmarkElement) {
        NodeList queryList = bookmarkElement.getElementsByTagName("queryList");
        int i = 0;
        int length = queryList == null ? 0 : queryList.getLength();
        while (i < length) {
            Element element = (Element)queryList.item(i);
            NodeList childNodes = element.getElementsByTagName("query");
            int k = 0;
            int length2 = childNodes == null ? 0 : childNodes.getLength();
            while (k < length2) {
                Element query = (Element)childNodes.item(k);
                bookmark.addQuery(XMLUtil.getElementText(query, "queryString"));
                ++k;
            }
            ++i;
        }
    }

    public void addBookmark(Bookmark b) {
        this.changed = true;
        if (!this.bookmarks.contains(b)) {
            Bookmark[] original = this.getBookmarks();
            this.bookmarks.add(b);
            this.support.firePropertyChange("bookmarks", original, this.getBookmarks());
        }
    }

    public void removeBookmark(Bookmark b) {
        this.changed = true;
        if (this.bookmarks.contains(b)) {
            Bookmark[] original = this.getBookmarks();
            this.bookmarks.remove(b);
            this.support.firePropertyChange("bookmarks", original, this.getBookmarks());
        }
    }

    public Bookmark[] getBookmarks() {
        return this.bookmarks.toArray(new Bookmark[this.bookmarks.size()]);
    }

    public String[] getBookmarkNames() {
        String[] bookmarkNames = new String[this.bookmarks.size()];
        int i = 0;
        while (i < bookmarkNames.length) {
            bookmarkNames[i] = ((Bookmark)this.bookmarks.get(i)).getName();
            ++i;
        }
        return bookmarkNames;
    }

    public JDBCDriver[] getJDBCDrivers() {
        if (this.drivers.isEmpty()) {
            this.addStandardDrivers();
        }
        ArrayList list = new ArrayList(this.drivers);
        Collections.sort(list);
        return list.toArray(new JDBCDriver[list.size()]);
    }

    public boolean isAnythingChanged() {
        boolean anythingChanged = this.changed;
        Iterator i = this.bookmarks.iterator();
        while (!anythingChanged && i.hasNext()) {
            Bookmark bookmark = (Bookmark)i.next();
            anythingChanged |= bookmark.isChanged();
        }
        return anythingChanged;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String getCopyName(String name) {
        String copyName = String.valueOf(Messages.getString("BookmarkView.CopyOf")) + name;
        int i = 1;
        while (this.find(copyName) != null) {
            copyName = String.valueOf(Messages.getString("BookmarkView.CopyOf")) + name + "(" + String.valueOf(i) + ")";
            ++i;
        }
        return copyName;
    }

    public JDBCDriver findDriver(String driverClassName, String[] driverFiles, String type) {
        JDBCDriver temp = new JDBCDriver(driverClassName, driverFiles, type);
        return this.findDriver(temp);
    }

    public JDBCDriver findDriver(JDBCDriver temp) {
        JDBCDriver result = null;
        Iterator i = this.drivers.iterator();
        while (result == null && i.hasNext()) {
            JDBCDriver driver = (JDBCDriver)i.next();
            if (!temp.equals((Object)driver)) continue;
            result = driver;
        }
        if (result == null) {
            this.addDriver(temp);
            result = temp;
        }
        return result;
    }

    public Bookmark[] getBookmarksUsingDriver(JDBCDriver driver) {
        Vector<Bookmark> bookmarkList = new Vector<Bookmark>();
        Iterator i = this.bookmarks.iterator();
        while (driver != null && i.hasNext()) {
            Bookmark bookmark = (Bookmark)i.next();
            if (!driver.equals((Object)bookmark.getJDBCDriver())) continue;
            bookmarkList.add(bookmark);
        }
        return bookmarkList.toArray(new Bookmark[bookmarkList.size()]);
    }

    public boolean removeDriver(JDBCDriver driver) {
        boolean found;
        boolean bl = found = this.getBookmarksUsingDriver(driver).length > 0;
        if (!found && driver != null && !SUN_JDBC_ODBC_DRIVER.equals(driver.getClassName())) {
            boolean deleted = this.drivers.remove(driver);
            if (deleted) {
                this.support.firePropertyChange("drivers", null, null);
            }
            return deleted;
        }
        return false;
    }
}

