/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.util.sql.TypesHelper;

public class ColumnImpl
implements Column,
Comparable {
    private long size;
    private boolean nullable;
    private int primaryKeyOrder;
    private String name;
    private Entity entity;
    private int numberOfFractionalDigits;
    private String typeName;
    private int type;
    private int position;
    private String remarks;
    private String defaultValue;

    public ColumnImpl(Entity entity, String name, String typeName, int type, long size, int numberOfFractionalDigits, boolean nullable, int position, String defaultValue, String remarks) {
        this.entity = entity;
        this.name = name;
        this.typeName = typeName;
        this.type = type;
        this.size = size;
        this.numberOfFractionalDigits = numberOfFractionalDigits;
        this.nullable = nullable;
        this.position = position;
        this.remarks = remarks;
        this.defaultValue = defaultValue;
        this.primaryKeyOrder = 0;
    }

    public int getPrimaryKeyOrder() {
        return this.primaryKeyOrder;
    }

    public boolean isPrimaryKey() {
        return this.getPrimaryKeyOrder() > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isReal() {
        return TypesHelper.isNumeric(this.type);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isNumeric() {
        return TypesHelper.isNumeric(this.type);
    }

    public int getType() {
        return this.type;
    }

    public Entity getParentEntity() {
        return this.entity;
    }

    public void setPrimaryKeyOrder(int i) {
        this.primaryKeyOrder = i;
    }

    public int compareTo(Object o) {
        ColumnImpl that = (ColumnImpl)o;
        if (this.isPrimaryKey() && that.isPrimaryKey()) {
            return this.primaryKeyOrder - that.primaryKeyOrder;
        }
        if (this.isPrimaryKey()) {
            return -1;
        }
        if (that.isPrimaryKey()) {
            return 1;
        }
        return this.position - that.position;
    }

    public long getSize() {
        return this.size;
    }

    public int getNumberOfFractionalDigits() {
        return this.numberOfFractionalDigits;
    }

    public String getRemarks() {
        return this.remarks == null ? "" : this.remarks;
    }

    public int getPosition() {
        return this.position;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

