/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.util.Displayable;
import com.quantum.util.DisplayableComparator;
import com.quantum.util.JarUtil;
import com.quantum.util.StringArrayComparator;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JDBCDriver
implements Comparable,
Displayable {
    private String name;
    private String version;
    private String className;
    private List jarFileNames = Collections.synchronizedList(new ArrayList());
    private String type;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public JDBCDriver(String className, String[] jarFileNames, String type) {
        this(className, jarFileNames, type, null, null);
    }

    public JDBCDriver(String className, String[] jarFileNames, String type, String name, String version) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.className = className;
        this.jarFileNames.addAll(Arrays.asList(jarFileNames));
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        if (className != null && !className.equals(this.className)) {
            String original = this.className;
            this.className = className;
            this.propertyChangeSupport.firePropertyChange("className", original, className);
        }
    }

    public String[] getJarFileNames() {
        return this.jarFileNames.toArray(new String[this.jarFileNames.size()]);
    }

    public void setJarFileNames(String[] jarFileNames) {
        StringArrayComparator comparator = new StringArrayComparator();
        if (comparator.compare(this.jarFileNames.toArray(new String[this.jarFileNames.size()]), jarFileNames) != 0) {
            String[] original = this.getJarFileNames();
            this.jarFileNames.clear();
            this.jarFileNames.addAll(Arrays.asList(jarFileNames));
            this.propertyChangeSupport.firePropertyChange("jarFileName", original, jarFileNames);
        }
    }

    public String getName() {
        return this.name == null || this.name.trim().length() == 0 ? this.getClassName() : this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals(this.name)) {
            String original = this.name;
            this.name = name;
            this.propertyChangeSupport.firePropertyChange("name", original, name);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version != null && !version.equals(this.version)) {
            String original = this.version;
            this.version = version;
            this.propertyChangeSupport.firePropertyChange("version", original, version);
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.equals((JDBCDriver)object);
    }

    private boolean equals(JDBCDriver that) {
        if (this.className == null && that.className != null) {
            return false;
        }
        if (this.className != null && !this.className.equals(that.className)) {
            return false;
        }
        if (new StringArrayComparator().compare(this.getJarFileNames(), that.getJarFileNames()) != 0) {
            return false;
        }
        if (this.type == null && that.type != null) {
            return false;
        }
        return this.type == null || this.type.equals(that.type);
    }

    public int hashCode() {
        int hashCode = 31;
        if (this.className != null) {
            hashCode ^= this.className.hashCode();
        }
        Iterator i = this.jarFileNames.iterator();
        while (i.hasNext()) {
            Object jarFile = i.next();
            if (jarFile == null) continue;
            hashCode ^= jarFile.hashCode();
        }
        if (this.type != null) {
            hashCode ^= this.type.hashCode();
        }
        return hashCode;
    }

    public Driver getDriver() {
        return JarUtil.loadDriver(this.getJarFileNames(), this.getClassName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.removePropertyChangeListener(arg0);
    }

    public void removePropertyChangeListener(String arg0, PropertyChangeListener arg1) {
        this.propertyChangeSupport.removePropertyChangeListener(arg0, arg1);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && !type.equals(this.type)) {
            String original = this.type;
            this.type = type;
            this.propertyChangeSupport.firePropertyChange("type", original, type);
        }
    }

    public int compareTo(Object object) {
        return new DisplayableComparator().compare((Object)this, object);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getJarFilePath() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.jarFileNames.iterator();
        while (i.hasNext()) {
            String element = (String)i.next();
            buffer.append(element);
            if (!i.hasNext()) continue;
            buffer.append(File.pathSeparator);
        }
        return buffer.toString();
    }
}

