/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.DatabaseObjectImpl;
import com.quantum.model.Package;
import com.quantum.model.Procedure;
import com.quantum.model.ProcedureImpl;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class PackageImpl
extends DatabaseObjectImpl
implements Package {
    Procedure[] procedures = null;

    public PackageImpl(Bookmark bookmark, String schema, String name) {
        super(bookmark, schema, name, "PACKAGE");
    }

    public Procedure[] getProcedures() {
        this.loadProcedures();
        return this.procedures;
    }

    private void loadProcedures() {
        if (this.procedures == null) {
            List procs = this.getProcsFromDatabase();
            this.procedures = procs.toArray(new Procedure[procs.size()]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getProcsFromDatabase() {
        ArrayList<ProcedureImpl> list = new ArrayList<ProcedureImpl>();
        try {
            Connection con = this.getBookmark().getConnection();
            DatabaseAdapter adapter = this.getBookmark().getAdapter();
            Statement stmt = con.createStatement();
            try {
                String sql;
                if (adapter != null && stmt != null && (sql = adapter.getProceduresQuery(this.getSchema(), this.getName())) != null) {
                    stmt.execute(sql);
                    ResultSet set = stmt.getResultSet();
                    try {
                        while (set.next()) {
                            ProcedureImpl p = new ProcedureImpl(this.getBookmark(), this.getSchema(), this, set.getString(1), set.getInt(2));
                            list.add(p);
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        set.close();
                        throw throwable;
                    }
                    set.close();
                }
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return list;
        }
        catch (NotConnectedException notConnectedException) {
            return list;
        }
        catch (SQLException sQLException) {}
        return list;
    }
}

