/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.DatabaseObjectImpl;
import com.quantum.model.Package;
import com.quantum.model.Procedure;
import com.quantum.model.ProcedureArgument;
import com.quantum.model.ProcedureArgumentImpl;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ProcedureImpl
extends DatabaseObjectImpl
implements Procedure {
    int overload;
    Package pack;
    ProcedureArgument[] columns = null;

    public ProcedureImpl(Bookmark bookmark, String schema, Package pack, String name, int overload) {
        super(bookmark, schema, name, "PROCEDURE");
        this.pack = pack;
        this.overload = overload;
    }

    public Package getPackage() {
        return this.pack;
    }

    public void setPackage(Package pack) {
        this.pack = pack;
    }

    public int getOverload() {
        return this.overload;
    }

    private String getPackageName() {
        return this.pack == null ? null : this.pack.getName();
    }

    public ProcedureArgument getReturnType() {
        this.loadArguments();
        return this.columns[0];
    }

    public ProcedureArgument[] getArguments() {
        this.loadArguments();
        return this.columns;
    }

    public ProcedureArgument getArgument(String name) {
        this.loadArguments();
        int i = 1;
        while (i < this.columns.length) {
            if (this.columns[i].getName().equals(name)) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    private void loadArguments() {
        if (this.columns == null) {
            List arguments = this.getArgumentsFromDatabase();
            this.columns = arguments.toArray(new ProcedureArgument[arguments.size()]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List getArgumentsFromDatabase() {
        ArrayList<ProcedureArgumentImpl> list = new ArrayList<ProcedureArgumentImpl>();
        try {
            Connection con = this.getBookmark().getConnection();
            DatabaseAdapter adapter = this.getBookmark().getAdapter();
            Statement stmt = con.createStatement();
            try {
                String sql;
                if (adapter != null && stmt != null && (sql = adapter.getProcedureArgumentsQuery(this.getSchema(), this.getPackageName(), this.getName(), this.getOverload())) != null) {
                    stmt.execute(sql);
                    ResultSet set = stmt.getResultSet();
                    try {
                        while (set.next()) {
                            ProcedureArgumentImpl p = new ProcedureArgumentImpl(set.getString(1), set.getInt(2), set.getString(3));
                            if (list.isEmpty() && p.getIndex() == 1) {
                                list.add(null);
                            }
                            list.add(p);
                        }
                        Object var8_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        set.close();
                        throw throwable;
                    }
                    set.close();
                }
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return list;
        }
        catch (NotConnectedException notConnectedException) {
            return list;
        }
        catch (SQLException sQLException) {}
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getBody() {
        String body = "";
        try {
            Connection con = this.getBookmark().getConnection();
            DatabaseAdapter adapter = this.getBookmark().getAdapter();
            Statement stmt = con.createStatement();
            try {
                String sql;
                if (adapter != null && stmt != null && (sql = adapter.getProcedureBodyStatement(this.getSchema(), this.getPackageName(), this.getName(), this.getOverload())) != null) {
                    stmt.execute(sql);
                    ResultSet set = stmt.getResultSet();
                    try {
                        while (set.next()) {
                            body = String.valueOf(body) + set.getString(1);
                        }
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        set.close();
                        throw throwable;
                    }
                    set.close();
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return body;
        }
        catch (NotConnectedException notConnectedException) {
            return body;
        }
        catch (SQLException sQLException) {}
        return body;
    }
}

