/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model.xml;

import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;

public class XMLMetadataIterator
implements Iterator {
    private String[] acceptedNames = null;
    NodeFilter filter;
    NodeList list;
    int position = 0;
    int lastPosition = 0;

    public XMLMetadataIterator(Document doc, int type) {
        this.list = doc.getDocumentElement().getChildNodes();
        this.position = 0;
        this.acceptedNames = type == 0 ? new String[]{"table", "view"} : new String[]{"table", "view", "sequence"};
        this.filter = type < 0 ? null : new MetadataFilter();
    }

    public boolean hasNext() {
        if (this.position >= this.list.getLength()) {
            return false;
        }
        return this.next(false) != null;
    }

    public Object next() {
        return this.next(true);
    }

    private Object next(boolean update) {
        Node node = null;
        if (this.position >= this.list.getLength()) {
            return null;
        }
        if (this.filter == null) {
            node = this.list.item(this.position);
            if (update) {
                ++this.position;
            }
            return node;
        }
        int tempPosition = this.position;
        boolean accepted = false;
        do {
            boolean bl = accepted = this.filter.acceptNode(node = this.list.item(tempPosition)) == 1;
        } while (++tempPosition < this.list.getLength() && !accepted);
        if (update) {
            this.position = tempPosition;
        }
        if (!accepted) {
            return null;
        }
        return node;
    }

    public void remove() {
    }

    class MetadataFilter
    implements NodeFilter {
        MetadataFilter() {
        }

        public short acceptNode(Node n) {
            if (n instanceof Element) {
                Element e = (Element)n;
                int i = 0;
                while (i < XMLMetadataIterator.this.acceptedNames.length) {
                    String name = XMLMetadataIterator.this.acceptedNames[i];
                    if (e.getNodeName().equals(name)) {
                        return 1;
                    }
                    ++i;
                }
                return 3;
            }
            return 3;
        }
    }
}

