/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.preferences;

import com.quantum.Messages;
import com.quantum.log.Severity;
import com.quantum.view.widget.ComboViewer;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

class SeverityFieldEditor
extends FieldEditor {
    private ComboViewer viewer;

    public SeverityFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelControl(parent);
        this.viewer = new ComboViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.viewer.setInput(Severity.getSeverities());
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        this.select(value);
    }

    protected void doLoadDefault() {
        String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.select(value);
    }

    private void select(String value) {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)Severity.getSeverity(value)));
    }

    protected void doStore() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Severity severity = (Severity)selection.getFirstElement();
        this.getPreferenceStore().setValue(this.getPreferenceName(), severity.getName());
    }

    public int getNumberOfControls() {
        return 2;
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Severity[]) {
                return (Severity[])inputElement;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LabelProviderImpl
    extends LabelProvider {
        LabelProviderImpl() {
        }

        public String getText(Object element) {
            if (element instanceof Severity) {
                return Messages.getString(element.getClass(), ((Severity)element).getName());
            }
            return super.getText(element);
        }
    }
}

