/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.properties;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class DatabaseInformationPropertyPage
extends PropertyPage {
    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Bookmark bookmark = ((TreeNode)this.getElement()).getBookmark();
        this.createDatabaseNameArea(composite, bookmark);
        return composite;
    }

    private void createErrorMessage(Composite composite, Exception e) {
        Label icon = new Label(composite, 0);
        icon.setLayoutData((Object)new GridData(770));
        icon.setImage(ImageStore.getImage("warning"));
        Label error = new Label(composite, 0);
        error.setLayoutData((Object)new GridData(770));
        error.setText(String.valueOf(Messages.getString(((Object)((Object)this)).getClass(), "error")) + (e.getMessage() == null ? "" : "\n" + e.getMessage()));
    }

    private void createDatabaseNameArea(Composite composite, Bookmark bookmark) {
        Label productLabel = new Label(composite, 0);
        productLabel.setText(Messages.getString(((Object)((Object)this)).getClass(), "product"));
        Label productDescriptionLabel = new Label(composite, 0);
        String description = null;
        if (bookmark.isConnected()) {
            try {
                description = bookmark.getDatabase().getInformation();
            }
            catch (NotConnectedException e) {
                this.createErrorMessage(composite, e);
            }
            catch (SQLException e) {
                this.createErrorMessage(composite, e);
            }
            catch (RuntimeException e) {
                this.createErrorMessage(composite, e);
            }
        }
        if (description == null) {
            description = Messages.getString(((Object)((Object)this)).getClass(), "unknown");
        }
        productDescriptionLabel.setText(description);
    }

    protected void performDefaults() {
    }

    public boolean performOk() {
        return true;
    }
}

