/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.properties;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Index;
import com.quantum.properties.EntityMetaDataPropertyPage;
import com.quantum.util.connection.NotConnectedException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class IndexPropertyPage
extends EntityMetaDataPropertyPage {
    protected int getNumberOfColumns() {
        return 4;
    }

    protected ITableLabelProvider getLabelProvider() {
        return new TableLabelProviderImpl();
    }

    protected IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Index[]) {
                    Index[] indeces = (Index[])inputElement;
                    ArrayList<IndexAdaptor> list = new ArrayList<IndexAdaptor>();
                    int i = 0;
                    int length = indeces == null ? 0 : indeces.length;
                    while (i < length) {
                        int j = 0;
                        int columns = indeces[i].getNumberOfColumns();
                        while (j < columns) {
                            list.add(new IndexAdaptor(indeces[i], j));
                            ++j;
                        }
                        ++i;
                    }
                    return list.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected Object getInput() throws NotConnectedException, SQLException {
        return this.getEntity().getIndexes();
    }

    private final class TableLabelProviderImpl
    extends LabelProvider
    implements ITableLabelProvider {
        static /* synthetic */ Class class$0;

        TableLabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2 && element instanceof IndexAdaptor) {
                return ImageStore.getImage("column");
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getColumnText(Object element, int columnIndex) {
            String label = null;
            if (element instanceof IndexAdaptor) {
                IndexAdaptor index = (IndexAdaptor)element;
                switch (columnIndex) {
                    case 0: {
                        if (index.getColumnNumber() != 0) break;
                        label = index.getIndex().getName();
                        break;
                    }
                    case 1: {
                        String string;
                        if (index.getColumnNumber() != 0) break;
                        if (index.getIndex().isUnique()) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz2;
                                try {
                                    clazz2 = Class.forName("com.quantum.properties.IndexPropertyPage");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz2;
                            }
                            string = Messages.getString(clazz, "true");
                        } else {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz3;
                                try {
                                    clazz3 = Class.forName("com.quantum.properties.IndexPropertyPage");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz3;
                            }
                            string = Messages.getString(clazz, "false");
                        }
                        label = string;
                        break;
                    }
                    case 2: {
                        label = index.getIndex().getColumnName(index.getColumnNumber());
                        break;
                    }
                    case 3: {
                        if (index.getIndex().isAscending(index.getColumnNumber())) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz4;
                                try {
                                    clazz4 = Class.forName("com.quantum.properties.IndexPropertyPage");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz4;
                            }
                            label = Messages.getString(clazz, "ascending");
                            break;
                        }
                        if (!index.getIndex().isDescending(index.getColumnNumber())) break;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz5;
                            try {
                                clazz5 = Class.forName("com.quantum.properties.IndexPropertyPage");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz5;
                        }
                        label = Messages.getString(clazz, "descending");
                        break;
                    }
                }
            }
            if (label == null) {
                return "";
            }
            String string = label;
            return string;
        }
    }

    class IndexAdaptor {
        private final Index index;
        private final int columnNumber;

        public IndexAdaptor(Index index, int columnNumber) {
            this.index = index;
            this.columnNumber = columnNumber;
        }

        public Index getIndex() {
            return this.index;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }
    }
}

