/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.sql.FilterRow;
import java.util.ArrayList;

public class FilterSort {
    private ArrayList filterList = new ArrayList();
    private ArrayList sortList = new ArrayList();
    private ArrayList ascDescList = new ArrayList();

    public void addFilter(String column, String operator, String value, boolean isString) {
        FilterRow row = new FilterRow();
        row.column = column;
        row.operator = operator;
        row.value = value;
        row.isString = isString;
        this.filterList.add(row);
    }

    public void clearFilters() {
        this.filterList.clear();
    }

    public void addSort(String column, String ascDesc) {
        int ind = this.sortList.indexOf(column);
        if (ind < 0) {
            this.sortList.add(column);
            this.ascDescList.add(ascDesc);
            return;
        }
        if (ind < this.ascDescList.size()) {
            this.ascDescList.remove(ind);
        }
        this.ascDescList.add(ind, ascDesc);
    }

    public void removeSort(String column) {
        int ind = this.sortList.indexOf(column);
        if (ind < 0) {
            return;
        }
        this.sortList.remove(ind);
        this.ascDescList.remove(ind);
    }

    public String toString() {
        int i;
        StringBuffer text = new StringBuffer();
        if (this.filterList.size() > 0) {
            text.append(" WHERE ");
            i = 0;
            while (i < this.filterList.size()) {
                FilterRow row = (FilterRow)this.filterList.get(i);
                text.append(row.column);
                text.append(" ");
                text.append(row.operator);
                text.append(" ");
                if (row.isString) {
                    text.append(FilterSort.escape(row.value));
                } else {
                    text.append(row.value);
                }
                text.append(" ");
                if (i < this.filterList.size() - 1) {
                    text.append("AND ");
                }
                ++i;
            }
        }
        if (this.sortList.size() > 0) {
            text.append(" ORDER BY ");
            i = 0;
            while (i < this.sortList.size()) {
                String value = (String)this.sortList.get(i);
                text.append(value);
                text.append(" ");
                text.append(this.ascDescList.get(i));
                if (i < this.sortList.size() - 1) {
                    text.append(", ");
                }
                ++i;
            }
        }
        return text.toString();
    }

    public static String escape(String original) {
        return String.valueOf('\'') + original + '\'';
    }
}

