/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.sql.SQLResultSetResults;
import com.quantum.view.SQLQueryView;
import com.quantum.view.tableview.ResultSetViewer;
import com.quantum.view.tableview.TableView;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.TabFolder;

public class SQLResultSetCollection {
    private static final SQLResultSetCollection instance = new SQLResultSetCollection();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List results = Collections.synchronizedList(new ArrayList());

    private SQLResultSetCollection() {
    }

    public static SQLResultSetCollection getInstance() {
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.addPropertyChangeListener(arg0);
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.removePropertyChangeListener(arg0);
    }

    public void addSQLResultSet(SQLResultSetResults resultSet) {
        SQLQueryView sqlView;
        SQLResultSetResults[] tempSQL = this.getResultSets();
        int iLength = tempSQL.length;
        boolean bExist = false;
        int nIndex = 0;
        int nScript = -1;
        nIndex = 0;
        while (nIndex < iLength) {
            if (tempSQL[nIndex].getEntity() == resultSet.getEntity()) {
                if (tempSQL[nIndex].getEntity() == null) {
                    nScript = nIndex;
                }
                if (tempSQL[nIndex].getConnectable() == resultSet.getConnectable() && tempSQL[nIndex].getQuery().equalsIgnoreCase(resultSet.getQuery())) {
                    bExist = true;
                    break;
                }
            }
            ++nIndex;
        }
        if (!bExist && (sqlView = SQLQueryView.getInstance()) != null && sqlView.isPinTab() && resultSet.getEntity() == null && nScript != -1) {
            bExist = true;
            nIndex = nScript;
        }
        if (!bExist) {
            this.results.add(resultSet);
            this.propertyChangeSupport.firePropertyChange("resultSets", null, resultSet);
        } else {
            TableView tView = TableView.getInstance();
            ResultSetViewer rsViewer = tView.findViewerFor(tempSQL[nIndex]);
            TabFolder tab = tView.getTabFolder();
            this.results.set(this.results.indexOf(tempSQL[nIndex]), resultSet);
            this.propertyChangeSupport.firePropertyChange("resultSets", tempSQL[nIndex], resultSet);
            tab.setSelection(tab.indexOf(rsViewer.getTabItem()));
        }
    }

    public void removeSQLResultSet(SQLResultSetResults resultSet) {
        if (this.results.remove(resultSet)) {
            this.propertyChangeSupport.firePropertyChange("resultSets", resultSet, null);
        }
    }

    public void removeAllSQLResultSet() {
        if (this.results.size() > 0) {
            this.results.clear();
        }
        this.propertyChangeSupport.firePropertyChange("resultSets", null, null);
    }

    public SQLResultSetResults[] getResultSets() {
        return this.results.toArray(new SQLResultSetResults[this.results.size()]);
    }
}

