/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.model.Entity;
import com.quantum.sql.FilterSort;
import com.quantum.sql.SQLResults;
import com.quantum.util.connection.Connectable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class SQLResultSetResults
extends SQLResults {
    private List rows = Collections.synchronizedList(new ArrayList());
    private List columns = Collections.synchronizedList(new ArrayList());
    private String query;
    private Connectable connectable;
    private final Entity entity;
    private String encoding = "";
    private FilterSort filterSort = null;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public SQLResultSetResults(String query, Connectable connectable, Entity entity) {
        this.query = query;
        this.connectable = connectable;
        this.entity = entity;
    }

    public String getColumnName(int columnNumber) {
        Column column = this.getColumn(columnNumber);
        return column == null ? "" : column.getName();
    }

    protected Column getColumn(int columnNumber) {
        return columnNumber <= this.columns.size() ? (Column)this.columns.get(columnNumber - 1) : null;
    }

    public Column[] getColumns() {
        return this.columns.toArray(new Column[this.columns.size()]);
    }

    protected void setColumns(Column[] columns) {
        Column[] original = this.getColumns();
        if (new ColumnArrayComparator().compare(original, columns) != 0) {
            this.columns.clear();
            this.columns.addAll(Arrays.asList(columns));
            this.propertyChangeSupport.firePropertyChange("columns", original, columns);
        }
    }

    public Object getElement(int column, int row) {
        return ((Row)this.rows.get(row - 1)).get(column);
    }

    public int getColumnCount() {
        if (this.columns.size() > 0) {
            return this.columns.size();
        }
        return 0;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String[] getColumnNames() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator i = this.columns.iterator();
        while (i.hasNext()) {
            Column column = (Column)i.next();
            names.add(column.getName());
        }
        return names.toArray(new String[names.size()]);
    }

    public boolean isResultSet() {
        return true;
    }

    public Row[] getRows() {
        return this.rows.toArray(new Row[this.rows.size()]);
    }

    public Iterator getRowIterator() {
        ArrayList list = new ArrayList(this.rows);
        return list.iterator();
    }

    public String getQuery() {
        return this.query;
    }

    public String getFilteredQuery() {
        if (this.filterSort == null) {
            return this.query;
        }
        return String.valueOf(this.query) + this.filterSort.toString();
    }

    public Connectable getConnectable() {
        return this.connectable;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isMetaData() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected abstract void parseResultSet(ResultSet var1) throws SQLException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void refresh(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            ResultSet resultSet = statement.executeQuery(this.getFilteredQuery());
            try {
                this.parseResultSet(resultSet);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                resultSet.close();
                throw throwable;
            }
            {
                Object var4_6 = null;
                resultSet.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            statement.close();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        statement.close();
    }

    protected void setRows(Row[] rows) {
        Row[] original = this.getRows();
        this.rows.clear();
        if (rows != null) {
            this.rows.addAll(Arrays.asList(rows));
        }
        this.propertyChangeSupport.firePropertyChange("rows", original, this.getRows());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public FilterSort getFilterSort() {
        return this.filterSort;
    }

    public void setFilterSort(FilterSort filterSort) {
        this.filterSort = filterSort;
    }

    public String[][] getDataAsStrings() {
        String[][] data = new String[this.rows.size()][this.columns.size()];
        int i = 0;
        while (i < this.rows.size()) {
            Row row = (Row)this.rows.get(i);
            String[] rowData = row.getAsStringArray();
            int j = 0;
            while (j < rowData.length) {
                data[i][j] = rowData[j];
                ++j;
            }
            ++i;
        }
        return data;
    }

    class ColumnArrayComparator
    implements Comparator {
        ColumnArrayComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return this.compare((Column[])arg0, (Column[])arg1);
        }

        public int compare(Column[] columns0, Column[] columns1) {
            if (columns0 == null && columns1 == null) {
                return 0;
            }
            if (columns0 == null) {
                return -1;
            }
            if (columns1 == null) {
                return 1;
            }
            if (columns0.length < columns1.length) {
                return -1;
            }
            if (columns0.length > columns1.length) {
                return 1;
            }
            int result = 0;
            int i = 0;
            int length = columns1 == null ? 0 : columns1.length;
            while (result == 0 && i < length) {
                result = this.compare(columns0[i], columns1[i]);
                ++i;
            }
            return result;
        }

        private int compare(Column column0, Column column1) {
            if (column0 == null && column1 == null) {
                return 0;
            }
            if (column0 == null) {
                return -1;
            }
            if (column1 == null) {
                return 1;
            }
            if (column0.getName() == null) {
                return -1;
            }
            if (column1.getName() == null) {
                return 1;
            }
            if (column0.getName() != null && column1.getName() != null && column0.getName().compareTo(column1.getName()) != 0) {
                return column0.getName().compareTo(column1.getName());
            }
            if (column0.getTypeDescription() == null) {
                return -1;
            }
            if (column1.getTypeDescription() == null) {
                return 1;
            }
            if (column0.getTypeDescription() != null && column1.getTypeDescription() != null && column0.getTypeDescription().compareTo(column1.getTypeDescription()) != 0) {
                return column0.getTypeDescription().compareTo(column1.getTypeDescription());
            }
            return column0.getSize() - column1.getSize();
        }
    }

    public class Row {
        private final List elements;

        Row(List elements) {
            this.elements = elements;
        }

        public Object get(int columnNumber) {
            return columnNumber > this.elements.size() || columnNumber <= 0 ? null : this.elements.get(columnNumber - 1);
        }

        public String[] getAsStringArray() {
            String[] resultArray = new String[this.elements.size()];
            int i = 0;
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                String element;
                resultArray[i] = element = iter.next().toString();
                ++i;
            }
            return resultArray;
        }

        public SQLResultSetResults getResultSet() {
            return SQLResultSetResults.this;
        }
    }

    public class Column {
        private final String name;
        private final int type;
        private final int size;
        private final String typeDescription;

        Column(String name, String typeDescription, int type, int size) {
            this.name = name;
            this.typeDescription = typeDescription;
            this.type = type;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public int getSize() {
            return this.size;
        }

        public int getType() {
            return this.type;
        }

        public String getTypeDescription() {
            return this.typeDescription;
        }
    }
}

