/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Entity;
import com.quantum.sql.SQLResults;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class SQLVirtualResultSet
extends SQLResults {
    private String query = "";
    private Statement statement = null;
    private ResultSet resultSet = null;
    private int knownNumberOfRows = 0;

    public SQLVirtualResultSet(Entity entity) {
        DatabaseAdapter adapter;
        Bookmark bookmark = entity.getBookmark();
        DatabaseAdapter databaseAdapter = adapter = bookmark == null ? null : bookmark.getAdapter();
        if (adapter == null) {
            return;
        }
        try {
            this.Initialize(adapter.buildSelect(entity, entity.getColumns(), null), entity.getBookmark().getConnection(), 1005, 1008);
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public SQLVirtualResultSet(Entity entity, int type, int concurrency) {
        DatabaseAdapter adapter;
        Bookmark bookmark = entity.getBookmark();
        DatabaseAdapter databaseAdapter = adapter = bookmark == null ? null : bookmark.getAdapter();
        if (adapter == null) {
            return;
        }
        try {
            this.Initialize(adapter.buildSelect(entity, entity.getColumns(), null), entity.getBookmark().getConnection(), type, concurrency);
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void Initialize(String query, Connection connection, int type, int concurrency) {
        if (connection == null) {
            return;
        }
        this.query = query;
        try {
            this.statement = connection.createStatement(type, concurrency);
            this.resultSet = this.statement.executeQuery(query);
            if (type == 1003) {
                return;
            }
            if (!this.resultSet.isLast()) {
                this.knownNumberOfRows = 1;
            }
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public boolean isResultSet() {
        return true;
    }

    public boolean isOpen() {
        return this.resultSet != null;
    }

    public int getKnownNumberOfRows() {
        return this.knownNumberOfRows;
    }

    public String getStringValue(int row, int column) {
        if (this.resultSet == null) {
            return null;
        }
        try {
            this.resultSet.absolute(row + 1);
            this.actKnownNumberOfRows();
            return this.resultSet.getString(column + 1);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void actKnownNumberOfRows() {
        if (this.resultSet == null) {
            return;
        }
        try {
            int nRowsNow = this.resultSet.getRow() + (this.resultSet.isLast() ? 0 : 1);
            this.knownNumberOfRows = Math.max(nRowsNow, this.knownNumberOfRows);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String[] getRowAsStringArray(int row) {
        if (this.resultSet == null) {
            return null;
        }
        try {
            this.resultSet.absolute(row + 1);
            this.actKnownNumberOfRows();
            return this.getRowAsStringArray();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String[] getRowAsStringArray() {
        String[] resultArray = null;
        try {
            int numColumns = this.resultSet.getMetaData().getColumnCount();
            resultArray = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                resultArray[i] = this.resultSet.getString(i + 1);
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultArray;
    }

    public boolean next() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public boolean isLast() {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    public String[] getColumnNames() {
        if (this.resultSet == null) {
            return null;
        }
        String[] resultArray = null;
        try {
            int numColumns = this.resultSet.getMetaData().getColumnCount();
            resultArray = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                resultArray[i] = this.resultSet.getMetaData().getColumnName(i + 1);
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultArray;
    }

    public boolean update(int row, int columnIndex, String valueStr) {
        if (row < 0 || columnIndex < 0) {
            return false;
        }
        try {
            this.resultSet.absolute(row + 1);
            this.resultSet.updateString(columnIndex + 1, valueStr);
            this.resultSet.updateRow();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean insertRow(Vector columns, Vector columnNames, Vector emptyColums) {
        try {
            this.resultSet.moveToInsertRow();
            int i = 0;
            while (i < columns.size()) {
                String stringValue = (String)columns.get(i);
                int len = stringValue.length();
                if (len > 0) {
                    if (columnNames == null) {
                        this.resultSet.updateString(i + 1, stringValue);
                    } else {
                        this.resultSet.updateString((String)columnNames.get(i), stringValue);
                    }
                } else if (columnNames == null) {
                    this.resultSet.updateNull(i + 1);
                } else {
                    this.resultSet.updateNull((String)columnNames.get(i));
                }
                ++i;
            }
            this.resultSet.insertRow();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isInsertCapable() {
        try {
            this.resultSet.moveToInsertRow();
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }
}

