/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import bsh.EvalError;
import bsh.Interpreter;
import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.actions.ExecuteAction;
import com.quantum.actions.ExplainAction;
import com.quantum.actions.ExportQueryAction;
import com.quantum.actions.ImportQueryAction;
import com.quantum.log.QuantumLog;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.parser.SQLProvider;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.QuantumUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.SQLQueryView;
import com.quantum.view.tableview.TableView;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionGroup;

class SQLQueryActionGroup
extends ActionGroup {
    private ExecuteAction executeAction;
    private ImportQueryAction importQueryAction;
    private ExportQueryAction exportQueryAction;
    private AutoCommitPreferenceAction autoCommitPreferenceAction;
    private RollbackAction rollbackAction;
    private CommitAction commitAction;
    private PinTabAction pintabAction;
    private PasteTableQueryAction pasteTableQueryAction;
    private Action explainAction;
    private Action clearAction;
    private Action cutAction;
    private Action copyAction;
    private Action copyAsJavaAction;
    private Action pasteFromJavaAction;
    private Action pasteAction;
    private Action selectAllAction;
    private final IViewPart view;
    private boolean autoCommitPreference = true;
    private boolean pintabPreference = true;

    public SQLQueryActionGroup(SQLQueryView view) {
        this.view = view;
        this.executeAction = new ExecuteAction((SQLProvider)view, view);
        this.explainAction = new ExplainAction(view, (IWorkbenchPart)view);
        this.importQueryAction = new ImportQueryAction();
        this.importQueryAction.init(this.view);
        this.exportQueryAction = new ExportQueryAction();
        this.exportQueryAction.init(this.view);
        this.autoCommitPreferenceAction = new AutoCommitPreferenceAction();
        this.autoCommitPreferenceAction.setChecked(this.autoCommitPreference);
        this.rollbackAction = new RollbackAction();
        this.commitAction = new CommitAction();
        this.clearAction = new ClearAction(view);
        this.cutAction = new CutAction(view.getControl());
        this.copyAction = new CopyAction(view.getControl());
        this.copyAsJavaAction = new CopyAsJavaAction(view.getControl());
        this.pasteFromJavaAction = new PasteFromJavaAction(view.getControl());
        this.pasteAction = new PasteAction(view.getControl());
        this.selectAllAction = new SelectAllAction(view.getControl());
        this.pintabAction = new PinTabAction();
        this.pintabAction.setChecked(this.pintabPreference);
        this.pasteTableQueryAction = new PasteTableQueryAction(view.getControl());
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.executeAction);
        menu.add((IAction)this.explainAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.cutAction);
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.add((IAction)this.selectAllAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add((IAction)this.executeAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.clearAction);
        actionBars.getMenuManager().add((IAction)this.importQueryAction);
        actionBars.getMenuManager().add((IAction)this.exportQueryAction);
        actionBars.getMenuManager().add((IContributionItem)new Separator());
        actionBars.getMenuManager().add((IAction)this.autoCommitPreferenceAction);
        actionBars.getMenuManager().add((IAction)this.rollbackAction);
        actionBars.getMenuManager().add((IAction)this.commitAction);
        actionBars.getMenuManager().add((IContributionItem)new Separator());
        actionBars.getMenuManager().add((IAction)this.copyAsJavaAction);
        actionBars.getMenuManager().add((IAction)this.pasteFromJavaAction);
        actionBars.getMenuManager().add((IAction)this.pasteTableQueryAction);
        actionBars.getMenuManager().add((IContributionItem)new Separator());
        actionBars.getMenuManager().add((IAction)this.pintabAction);
        actionBars.setGlobalActionHandler("cut", (IAction)this.cutAction);
        actionBars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        actionBars.setGlobalActionHandler("paste", (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
    }

    protected Shell getShell() {
        return this.view.getSite().getShell();
    }

    public ExecuteAction getExecuteAction() {
        return this.executeAction;
    }

    public boolean isAutoCommitPreference() {
        return this.autoCommitPreference;
    }

    public void setAutoCommitPreference(boolean autoCommitPreference) {
        this.autoCommitPreference = autoCommitPreference;
    }

    public boolean isPinTabPreference() {
        return this.pintabPreference;
    }

    public void setPinTabPreference(boolean pintabPreference) {
        this.pintabPreference = pintabPreference;
    }

    public void dispose() {
        this.executeAction.dispose();
        super.dispose();
    }

    private class ClearAction
    extends Action {
        private final SQLProvider sqlProvider;

        public ClearAction(SQLProvider sqlProvider) {
            this.sqlProvider = sqlProvider;
            this.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
            this.setToolTipText(Messages.getString("sqlqueryview.clear"));
        }

        public void run() {
            this.sqlProvider.clear();
        }
    }

    private class AutoCommitPreferenceAction
    extends Action {
        public AutoCommitPreferenceAction() {
            super(Messages.getString("SQLQueryView.AutoCommit"));
            this.setToolTipText(Messages.getString("SQLQueryView.AutoCommit"));
            this.setImageDescriptor(ImageStore.getImageDescriptor("autocommit"));
        }

        public void run() {
            SQLQueryActionGroup.this.setAutoCommitPreference(this.isChecked());
        }
    }

    private class RollbackAction
    extends Action {
        public RollbackAction() {
            this.setText(Messages.getString("SQLQueryView.RollBack"));
            this.setToolTipText(Messages.getString("SQLQueryView.RollBack"));
        }

        public void run() {
            Bookmark[] bookmarks = BookmarkCollection.getInstance().getBookmarks();
            int i = 0;
            int length = bookmarks == null ? 0 : bookmarks.length;
            while (i < length) {
                try {
                    if (bookmarks[i].isConnected() && !bookmarks[i].getConnection().getAutoCommit()) {
                        MultiSQLServer.getInstance().rollback(bookmarks[i].getConnection());
                    }
                }
                catch (SQLException e) {
                    SQLExceptionDialog.openException(SQLQueryActionGroup.this.getShell(), bookmarks[i], e);
                }
                catch (NotConnectedException e) {
                    ExceptionDisplayDialog.openError(SQLQueryActionGroup.this.getShell(), null, null, e);
                }
                ++i;
            }
        }
    }

    private class CutAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public CutAction(StyledText widget) {
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("cut"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "cut"));
        }

        public void run() {
            this.widget.cut();
        }
    }

    private class CopyAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public CopyAction(StyledText widget) {
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "copy"));
        }

        public void run() {
            this.widget.copy();
        }
    }

    private class CopyAsJavaAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public CopyAsJavaAction(StyledText widget) {
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("javacup"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "copyAsJava"));
        }

        public void run() {
            if (this.widget.getText().length() > 0) {
                QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{QuantumUtil.convertSqlToJava(this.widget.getText())}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
    }

    private class PasteFromJavaAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public PasteFromJavaAction(StyledText widget) {
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("export"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "pasteFromJava"));
        }

        public void run() {
            String toChange = "";
            toChange = (String)QuantumPlugin.getDefault().getSysClip().getContents((Transfer)TextTransfer.getInstance());
            if (toChange.length() > 0) {
                while (toChange.endsWith(" ") || toChange.endsWith(";") || toChange.endsWith("\r") || toChange.endsWith("\n")) {
                    toChange = toChange.substring(0, toChange.length() - 1);
                }
                toChange = toChange.replaceAll("\n", "\"\\\\n\"+");
                toChange = toChange.replaceAll("\r", "\"\\\\r\"+");
                toChange = "print (" + toChange + ");";
                ByteArrayOutputStream outStr = new ByteArrayOutputStream();
                PrintStream printOut = new PrintStream(outStr);
                ByteArrayOutputStream errStr = new ByteArrayOutputStream();
                PrintStream printErr = new PrintStream(errStr);
                Interpreter i = new Interpreter(null, printOut, printErr, false);
                try {
                    i.eval(toChange);
                    String textOut = outStr.toString();
                    textOut = textOut.replaceAll("\\\\n", "\n");
                    textOut = textOut.replaceAll("\\\\r", "\r");
                    this.widget.insert(textOut);
                }
                catch (EvalError e) {
                    QuantumLog.getInstance().error("Problem evaluating statement: " + toChange, e);
                    Status error = new Status(4, QuantumPlugin.getDefault().toString(), 1, e.getMessage(), null);
                    ErrorDialog.openError((Shell)SQLQueryActionGroup.this.getShell(), (String)"Paste operation failed", (String)"Probably the clipboard contents are not valid java code. See the Quantum log for more info.", (IStatus)error);
                }
            }
        }
    }

    private class PasteAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public PasteAction(StyledText widget) {
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("paste"));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "paste"));
        }

        public void run() {
            this.widget.paste();
        }
    }

    private class SelectAllAction
    extends Action {
        private final StyledText widget;
        static /* synthetic */ Class class$0;

        public SelectAllAction(StyledText widget) {
            this.widget = widget;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.view.SQLQueryActionGroup");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setText(Messages.getString(clazz, "selectAll"));
        }

        public void run() {
            this.widget.selectAll();
        }
    }

    private class CommitAction
    extends Action {
        public CommitAction() {
            this.setText(Messages.getString("SQLQueryView.Commit"));
            this.setToolTipText(Messages.getString("SQLQueryView.Commit"));
        }

        public void run() {
            Bookmark[] bookmarks = BookmarkCollection.getInstance().getBookmarks();
            int i = 0;
            int length = bookmarks == null ? 0 : bookmarks.length;
            while (i < length) {
                try {
                    if (bookmarks[i].isConnected() && !bookmarks[i].getConnection().getAutoCommit()) {
                        MultiSQLServer.getInstance().commit(bookmarks[i].getConnection());
                    }
                }
                catch (SQLException e) {
                    SQLExceptionDialog.openException(SQLQueryActionGroup.this.getShell(), bookmarks[i], e);
                }
                catch (NotConnectedException e) {
                    ExceptionDisplayDialog.openError(SQLQueryActionGroup.this.getShell(), null, null, e);
                }
                ++i;
            }
        }
    }

    private class PinTabAction
    extends Action {
        public PinTabAction() {
            super(Messages.getString("SQLQueryView.PinTab"));
            this.setToolTipText(Messages.getString("SQLQueryView.PinTab"));
        }

        public void run() {
            SQLQueryActionGroup.this.setPinTabPreference(this.isChecked());
        }
    }

    private class PasteTableQueryAction
    extends Action {
        StyledText widget;

        public PasteTableQueryAction(StyledText widget) {
            super(Messages.getString("SQLQueryView.PasteTableQuery"));
            this.widget = widget;
            this.setImageDescriptor(ImageStore.getImageDescriptor("paste"));
            this.setToolTipText(Messages.getString("SQLQueryView.PasteTableQuery"));
        }

        public void run() {
            SQLResultSetResults displayedResultSet = TableView.getInstance().getSelectedResultSet();
            if (displayedResultSet != null) {
                this.widget.insert(displayedResultSet.getFilteredQuery());
            } else {
                MessageDialog.openInformation((Shell)SQLQueryActionGroup.this.getShell(), (String)"Paste operation failed", (String)"Probably there is no active Result Set in the table view.");
            }
        }
    }
}

