/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.search.SearchEntry;
import com.quantum.search.SearchResults;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class SQLSearchResults
extends ViewPart
implements PropertyChangeListener {
    private Color debugColor;
    private Color warningColor;
    private Color defaultColor;
    private Color errorColor;
    private Color infoColor;
    private StyledText widget;
    private static final String newLine = "\n";
    private int numberSinceLastPurge = 0;
    private Action copyAction = new Action(){

        public void run() {
            SQLSearchResults.this.widget.copy();
        }
    };
    private Action selectAllAction = new Action(){

        public void run() {
            SQLSearchResults.this.widget.selectAll();
        }
    };
    private Action clearAction = new Action(){

        public void run() {
            SearchResults.getInstance().clear();
        }
    };

    public void createPartControl(Composite parent) {
        this.initializeColors();
        this.widget = new StyledText(parent, 768);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("copy", (IAction)this.copyAction);
        bars.setGlobalActionHandler("selectAll", (IAction)this.selectAllAction);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        this.clearAction.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
        this.clearAction.setToolTipText(Messages.getString("SQLSearchResults.ClearSearch"));
        toolBar.add((IAction)this.clearAction);
        this.widget.setEditable(false);
        SearchResults.getInstance().addPropertyChangeListener(this);
    }

    private void initializeColors() {
        this.debugColor = this.infoColor = Display.getCurrent().getSystemColor(9);
        this.defaultColor = this.infoColor;
        this.errorColor = Display.getCurrent().getSystemColor(4);
        this.warningColor = Display.getCurrent().getSystemColor(8);
    }

    private void addEntry(SearchEntry entry) {
        if (entry.isFullyQualified()) {
            String text = entry.getTable();
            int start = this.widget.getText().length();
            StyleRange styleRange = new StyleRange();
            styleRange.start = start;
            styleRange.length = text.length() + 2;
            styleRange.foreground = this.getColor("TABLE");
            this.widget.append(String.valueOf(text) + "; ");
            this.widget.setStyleRange(styleRange);
            text = entry.getColumn();
            start = this.widget.getText().length();
            styleRange = new StyleRange();
            styleRange.start = start;
            styleRange.length = text.length() + 2;
            styleRange.foreground = this.getColor("COLUMN");
            this.widget.append(String.valueOf(text) + "; ");
            this.widget.setStyleRange(styleRange);
            text = String.valueOf(entry.getValue()) + newLine;
            start = this.widget.getText().length();
            styleRange = new StyleRange();
            styleRange.start = start;
            styleRange.length = text.length();
            styleRange.foreground = this.getColor("VALUE");
            this.widget.append(text);
            this.widget.setStyleRange(styleRange);
        } else {
            String text = String.valueOf(entry.toString()) + newLine;
            int start = this.widget.getText().length();
            StyleRange styleRange = new StyleRange();
            styleRange.start = start;
            styleRange.length = text.length();
            styleRange.foreground = this.getColor("MESSAGE");
            this.widget.append(text);
            this.widget.setStyleRange(styleRange);
        }
        this.scrollToBottom();
    }

    public static SQLSearchResults getInstance() {
        return (SQLSearchResults)QuantumPlugin.getDefault().getView("com.quantum.view.SQLSearchResults");
    }

    private Color getColor(String what) {
        if (what.equals("TABLE")) {
            return this.warningColor;
        }
        if (what.equals("COLUMN")) {
            return this.errorColor;
        }
        if (what.equals("VALUE")) {
            return this.defaultColor;
        }
        return this.defaultColor;
    }

    public void dispose() {
        SearchResults.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    protected void scrollToBottom() {
        StyledTextContent document = this.widget.getContent();
        int length = document.getCharCount();
        if (length > 0) {
            this.widget.setCaretOffset(length);
            this.widget.showSelection();
        }
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (event.getNewValue() == null || SQLSearchResults.this.shouldRefresh()) {
                        SQLSearchResults.this.setText(SearchResults.getInstance().getEntries());
                    }
                }
            });
        }
    }

    private boolean shouldRefresh() {
        this.numberSinceLastPurge = (this.numberSinceLastPurge + 1) % (SearchResults.getInstance().getNumberOfEntries() / 2);
        return this.numberSinceLastPurge == 0;
    }

    private void setText(SearchEntry[] entries) {
        this.widget.setText("");
        int i = 0;
        int length = entries == null ? 0 : entries.length;
        while (i < length) {
            this.addEntry(entries[i]);
            ++i;
        }
    }
}

