/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Bookmark;
import com.quantum.model.Schema;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.LabelDecorationInstructions;
import com.quantum.view.bookmark.QueryListNode;
import com.quantum.view.bookmark.QuickListNode;
import com.quantum.view.bookmark.SchemaNode;
import com.quantum.view.bookmark.TreeNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class BookmarkNode
extends TreeNode
implements PropertyChangeListener {
    private Bookmark bookmark;
    private QuickListNode quickListNode;
    private QueryListNode queryListNode;

    public BookmarkNode(TreeNode parent, Bookmark bookmark) {
        super(parent);
        this.bookmark = bookmark;
        this.bookmark.addPropertyChangeListener(this);
    }

    public Object[] getChildren() throws NotConnectedException, SQLException {
        if (this.bookmark.isConnected() && this.children.isEmpty()) {
            this.initializeChildren();
        }
        if (this.bookmark.isConnected()) {
            return this.children.toArray(new TreeNode[this.children.size()]);
        }
        return BookmarkListNode.EMPTY_ARRAY;
    }

    protected void initializeChildren() throws NotConnectedException, SQLException {
        boolean changed = false;
        HashMap<String, TreeNode> temp = new HashMap<String, TreeNode>();
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            TreeNode node = (TreeNode)i.next();
            if (!(node instanceof SchemaNode)) continue;
            temp.put(node.getName(), node);
        }
        this.children.clear();
        if (this.quickListNode == null) {
            this.quickListNode = new QuickListNode(this);
        }
        if (this.queryListNode == null) {
            this.queryListNode = new QueryListNode(this);
        }
        this.children.add(this.quickListNode);
        this.children.add(this.queryListNode);
        Bookmark bookmark = this.getBookmark();
        Schema[] schemas = bookmark.getSchemas();
        int i2 = 0;
        int length = schemas == null ? 0 : schemas.length;
        while (i2 < length) {
            SchemaNode node = (SchemaNode)temp.remove(schemas[i2].getDisplayName());
            if (node == null) {
                this.children.add(new SchemaNode(this, schemas[i2]));
            } else {
                changed = true;
                this.children.add(node);
            }
            ++i2;
        }
        Iterator i22 = temp.values().iterator();
        while (i22.hasNext()) {
            ((TreeNode)i22.next()).dispose();
            changed = true;
        }
        if (temp.size() > 0 || changed) {
            this.firePropertyChange("children", null, null);
        }
    }

    public boolean hasChildren() {
        if (this.bookmark.isConnected() && this.children.isEmpty()) {
            return true;
        }
        if (!this.bookmark.isConnected()) {
            return false;
        }
        return this.children != null && this.children.size() > 0;
    }

    protected void dispose() {
        try {
            this.bookmark.removePropertyChangeListener(this);
            if (this.bookmark.isConnected()) {
                this.bookmark.disconnect();
            }
        }
        catch (SQLException sQLException) {}
    }

    public String getName() {
        return this.bookmark == null ? "<<new>>" : this.bookmark.getName();
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    protected String getImageName() {
        return this.bookmark.isConnected() ? "connected.gif" : "bookmarks.gif";
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("connected".equals(event.getPropertyName())) {
            if (Boolean.FALSE.equals(event.getNewValue())) {
                this.removeAllChildren();
            }
            this.firePropertyChange("connected", event.getOldValue(), event.getNewValue());
        } else if ("schemas".equals(event.getPropertyName())) {
            try {
                this.initializeChildren();
            }
            catch (NotConnectedException notConnectedException) {
                this.children.clear();
            }
            catch (SQLException sQLException) {
                this.children.clear();
            }
            this.firePropertyChange("children", event.getOldValue(), event.getNewValue());
        } else if ("name".equals(event.getPropertyName())) {
            this.firePropertyChange("name", event.getOldValue(), event.getNewValue());
        }
    }

    protected void removeAllChildren() {
        if (this.quickListNode != null) {
            this.quickListNode.dispose();
            this.quickListNode = null;
        }
        if (this.queryListNode != null) {
            this.queryListNode.dispose();
            this.queryListNode = null;
        }
        super.removeAllChildren();
    }

    public String getLabelDecorations(LabelDecorationInstructions labelDecorationInstructions) {
        if (!labelDecorationInstructions.isDatabaseDataVisible()) {
            return null;
        }
        if (!this.bookmark.isConnected()) {
            return null;
        }
        try {
            String decoration = this.bookmark.getDatabase().getInformation();
            return decoration == null ? null : "[" + decoration + "]";
        }
        catch (NotConnectedException notConnectedException) {
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

