/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Column;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.TreeNode;

public class ColumnNode
extends TreeNode {
    private Column column;

    public ColumnNode(TreeNode parent, Column column) {
        super(parent);
        this.column = column;
    }

    public Object[] getChildren() {
        return BookmarkListNode.EMPTY_ARRAY;
    }

    public boolean hasChildren() {
        return false;
    }

    public String getName() {
        return this.column.getName();
    }

    protected String getImageName() {
        return this.column.isPrimaryKey() ? "keycolumn.gif" : "column.gif";
    }

    public String getLabelName() {
        String label = String.valueOf(this.getName()) + " : " + this.column.getTypeName();
        if (this.column.isNumeric()) {
            if (this.column.getSize() > 0L || this.column.getNumberOfFractionalDigits() > 0) {
                label = String.valueOf(label) + "(" + Long.toString(this.column.getSize());
                if (this.column.getNumberOfFractionalDigits() > 0) {
                    label = String.valueOf(label) + "," + Integer.toString(this.column.getNumberOfFractionalDigits());
                }
                label = String.valueOf(label) + ")";
            }
        } else if (this.column.getSize() > 0L) {
            label = String.valueOf(label) + "(" + Long.toString(this.column.getSize()) + ")";
        }
        return label;
    }

    protected void initializeChildren() {
    }

    protected boolean isInitialized() {
        return true;
    }

    public Column getColumn() {
        return this.column;
    }

    void setColumn(Column column) {
        if (this.column == null || !this.column.equals(column)) {
            Column original = column;
            this.column = column;
            this.firePropertyChange("column", original, column);
        }
    }
}

