/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.model.Bookmark;
import com.quantum.model.xml.ModelToXMLConverter;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.QuantumUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLRenderer;
import com.quantum.view.bookmark.BookmarkClipboard;
import com.quantum.view.bookmark.BookmarkNode;
import com.quantum.view.bookmark.ColumnNode;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.bookmark.QueryNode;
import com.quantum.view.bookmark.QuickListNode;
import com.quantum.view.bookmark.SchemaNode;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.w3c.dom.Document;

final class CopyAction
extends SelectionListenerAction {
    private BookmarkClipboard bookmarkClipboard;
    IViewPart view;
    static /* synthetic */ Class class$0;

    public CopyAction(IViewPart view, BookmarkClipboard bookmarkClipboard, ISelectionProvider selectionProvider) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.view.bookmark.CopyAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(String.valueOf(clazz.getName()) + ".text"));
        this.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
        this.bookmarkClipboard = bookmarkClipboard;
        this.view = view;
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void run() {
        List list = this.getSelectedNonResources();
        Object selection = list.get(0);
        String copyText = null;
        if (selection instanceof BookmarkNode) {
            Bookmark bookmark = ((BookmarkNode)selection).getBookmark();
            this.bookmarkClipboard.setBookmark(bookmark);
            copyText = bookmark.getName();
        } else if (selection instanceof DbObjectNode || selection instanceof GroupNode || selection instanceof SchemaNode || selection instanceof QuickListNode) {
            Document doc;
            try {
                doc = ModelToXMLConverter.getInstance().convertList(list, null, false);
            }
            catch (NotConnectedException e) {
                ExceptionDisplayDialog.openError(this.view.getSite().getShell(), null, null, e);
                e.printStackTrace();
                return;
            }
            catch (SQLException e) {
                SQLExceptionDialog.openException(this.view.getSite().getShell(), null, e);
                e.printStackTrace();
                return;
            }
            copyText = XMLRenderer.render(doc);
        } else if (selection instanceof ColumnNode) {
            Iterator iter = list.iterator();
            IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
            while (iter.hasNext()) {
                ColumnNode column;
                Object current = iter.next();
                if (!(current instanceof ColumnNode) || (column = (ColumnNode)current) == null) continue;
                copyText = String.valueOf(copyText) + column.getName();
                if (!iter.hasNext()) continue;
                copyText = String.valueOf(copyText) + QuantumUtil.trasposeEscape(store.getString("copyColumnSeparator"));
            }
        } else if (selection instanceof QueryNode) {
            copyText = ((QueryNode)selection).getQuery();
        }
        if (copyText != null) {
            QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{copyText}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = super.updateSelection(selection);
        return enabled;
    }
}

