/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.DatabaseObject;
import com.quantum.model.SchemaHolder;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class DbObjectNode
extends TreeNode {
    DatabaseObject object;
    private boolean longFormName;

    public DbObjectNode(TreeNode parent, DatabaseObject object) {
        this(parent, object, false);
    }

    public DbObjectNode(TreeNode parent, DatabaseObject object, boolean longFormName) {
        super(parent);
        SchemaHolder schemaHolder;
        this.object = object;
        this.longFormName = longFormName;
        if (parent instanceof SchemaHolder && !(schemaHolder = (SchemaHolder)((Object)parent)).getSchema().getDisplayName().equals(object.getSchema())) {
            this.longFormName = true;
        }
    }

    public DatabaseObject getDatabaseObject() {
        return this.object;
    }

    protected void setDatabaseObject(DatabaseObject object) {
        this.object = object;
    }

    public String getName() {
        return this.object.getName();
    }

    public String getLabelName() {
        return this.longFormName ? this.object.getQualifiedName() : this.object.getName();
    }

    protected String getImageName() {
        return null;
    }

    public Object[] getChildren() throws NotConnectedException, SQLException {
        return BookmarkListNode.EMPTY_ARRAY;
    }

    public boolean hasChildren() {
        return false;
    }

    protected void initializeChildren() throws SQLException, NotConnectedException {
    }

    protected Map getChildrenAsMap() {
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>();
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            TreeNode node = (TreeNode)i.next();
            map.put(node.getName(), node);
        }
        return map;
    }
}

