/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Schema;
import com.quantum.model.SchemaHolder;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.DbObjectNodeFactory;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class GroupNode
extends TreeNode
implements Comparable,
SchemaHolder {
    private String type = null;
    private Schema schema = null;
    private boolean initialized = false;

    public GroupNode(TreeNode parent, Schema schema, String type) {
        super(parent);
        this.schema = schema;
        this.type = type;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public boolean hasChildren() {
        if (!this.isInitialized()) {
            return true;
        }
        return !this.children.isEmpty();
    }

    public Object[] getChildren() {
        if (!this.isInitialized() && this.getBookmark().isConnected()) {
            this.initializeChildren();
        }
        return this.children.toArray(new TreeNode[this.children.size()]);
    }

    protected void initializeChildren() {
        try {
            boolean firstTimeInitialization = !this.isInitialized();
            HashMap<String, TreeNode> temp = new HashMap<String, TreeNode>();
            Iterator i = this.children.iterator();
            while (i.hasNext()) {
                TreeNode treeNode = (TreeNode)i.next();
                temp.put(treeNode.getName(), treeNode);
            }
            this.children.clear();
            Bookmark bookmark = this.getBookmark();
            DatabaseObject[] entities = bookmark.getObjectsForSchema(this.schema, this.type);
            int i2 = 0;
            int length = entities == null ? 0 : entities.length;
            while (i2 < length) {
                String name = entities[i2].getName();
                DbObjectNode objectNode = (DbObjectNode)temp.remove(name);
                if (objectNode == null) {
                    this.children.add(DbObjectNodeFactory.create(this, entities[i2]));
                } else {
                    objectNode.setDatabaseObject(entities[i2]);
                    this.children.add(objectNode);
                }
                ++i2;
            }
            Iterator i22 = temp.values().iterator();
            while (i22.hasNext()) {
                ((TreeNode)i22.next()).dispose();
            }
            Collections.sort(this.children);
            if (!firstTimeInitialization) {
                this.firePropertyChange("children", null, null);
            }
            this.initialized = true;
        }
        catch (SQLException sQLException) {}
    }

    public String getName() {
        return Messages.getString(String.valueOf(this.getClass().getName()) + "." + this.type);
    }

    protected String getImageName() {
        return "entitygroup.gif";
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }
}

