/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Package;
import com.quantum.model.Procedure;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.ProcedureNode;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.Map;

public class PackageNode
extends DbObjectNode {
    boolean initialized = false;

    public PackageNode(TreeNode parent, Package object) {
        super(parent, object, false);
    }

    protected String getImageName() {
        return "all_procedures";
    }

    public Package getPackage() {
        return (Package)this.getDatabaseObject();
    }

    public Object[] getChildren() throws NotConnectedException, SQLException {
        if (!this.isInitialized()) {
            this.initializeChildren();
        }
        if (this.children.size() > 0) {
            return this.children.toArray(new ProcedureNode[this.children.size()]);
        }
        return BookmarkListNode.EMPTY_ARRAY;
    }

    public boolean hasChildren() {
        return true;
    }

    protected void initializeChildren() throws SQLException, NotConnectedException {
        boolean wasInitialized = this.isInitialized();
        Map map = this.getChildrenAsMap();
        Procedure[] procedures = this.getPackage().getProcedures();
        this.children.clear();
        int i = 0;
        int length = procedures == null ? 0 : procedures.length;
        while (i < length) {
            ProcedureNode node = (ProcedureNode)map.get(procedures[i].getName());
            if (node == null) {
                this.children.add(new ProcedureNode((TreeNode)this, procedures[i]));
            } else {
                node.setProcedure(procedures[i]);
                this.children.add(node);
            }
            if (wasInitialized) {
                this.firePropertyChange("procedures", null, null);
            }
            ++i;
        }
    }
}

