/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.view.tableview.ResultSetViewer;
import com.quantum.view.tableview.TableView;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class CopyAction
extends Action {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final TableView view;

    public CopyAction(TableView view) {
        this.view = view;
        this.setText(Messages.getString(((Object)((Object)this)).getClass(), "text"));
        this.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
    }

    public void run() {
        Table table = this.getTable();
        if (table != null) {
            TableItem[] items = table.getSelection();
            StringBuffer text = new StringBuffer();
            TableColumn[] cols = table.getColumns();
            int j = 0;
            while (j < cols.length) {
                text.append(cols[j].getText());
                text.append('\t');
                ++j;
            }
            text.append(LINE_SEPARATOR);
            int i = 0;
            while (i < items.length) {
                int columns = table.getColumnCount();
                int col = 0;
                while (col < columns) {
                    text.append(items[i].getText(col));
                    text.append('\t');
                    ++col;
                }
                text.append(LINE_SEPARATOR);
                ++i;
            }
            if (text.length() > 0) {
                QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
    }

    private Table getTable() {
        ResultSetViewer viewer = this.view.getSelectedResultSetViewer();
        return viewer == null ? null : viewer.getTable();
    }
}

