/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.Scrollable;
import com.quantum.view.tableview.ResultSetAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;

public class PreviousPageAction
extends ResultSetAction
implements PropertyChangeListener {
    private SQLResultSetResults resultSet;

    public PreviousPageAction(IViewPart view, ISelectionProvider selectionProvider) {
        super(view, selectionProvider);
        this.setText(Messages.getString(this.getClass(), "text"));
        this.setImageDescriptor(ImageStore.getImageDescriptor("previous"));
        this.setToolTipText(Messages.getString(this.getClass(), "text"));
        this.setEnabled(this.hasPreviousPage((IStructuredSelection)selectionProvider.getSelection()));
    }

    protected void executeResultSetAction(SQLResultSetResults results) throws SQLException {
        if (results instanceof Scrollable) {
            ((Scrollable)((Object)results)).previousPage(this.getConnection(results));
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.setResultSet(this.getResultSet(selection));
        return this.hasPreviousPage(selection);
    }

    private void setResultSet(SQLResultSetResults results) {
        if (this.resultSet != null) {
            this.resultSet.removePropertyChangeListener(this);
        }
        this.resultSet = results;
        if (results != null) {
            this.resultSet.addPropertyChangeListener(this);
        }
    }

    private SQLResultSetResults getResultSet(IStructuredSelection selection) {
        return selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof SQLResultSetResults ? (SQLResultSetResults)selection.getFirstElement() : null;
    }

    private boolean hasPreviousPage(IStructuredSelection selection) {
        return !selection.isEmpty() && selection.getFirstElement() instanceof Scrollable && ((Scrollable)selection.getFirstElement()).hasPreviousPage();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("rows".equals(event.getPropertyName())) {
            this.setEnabled(this.hasPreviousPage(this.getStructuredSelection()));
        }
    }
}

