/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.Messages;
import com.quantum.adapters.AdapterFactory;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.JDBCDriver;
import com.quantum.wizards.URLBuilder;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public abstract class URLSetupControl
extends Composite {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private String urlPattern;
    private Map properties = Collections.synchronizedMap(new HashMap());
    private final JDBCDriver driver;
    private String connectionURL;
    static /* synthetic */ Class class$0;

    public URLSetupControl(Composite parent, JDBCDriver driver) {
        super(parent, 0);
        this.driver = driver;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        this.urlPattern = AdapterFactory.getInstance().getURLPattern(driver.getClassName());
        this.setPropertyDefaults();
        this.setConnectionURL(URLBuilder.createURL(this.urlPattern, this.getProperties()));
    }

    protected void createPart() {
        Group group = new Group((Composite)this, 16);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.wizards.URLSetupControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        group.setText(Messages.getString(clazz, "text"));
        group.setLayoutData((Object)new GridData(770));
        this.createPart((Composite)group);
    }

    private void setPropertyDefaults() {
        DatabaseAdapter adapter = AdapterFactory.getInstance().getAdapter(this.getDriver().getType());
        Map properties = adapter == null ? new HashMap() : adapter.getDefaultConnectionParameters();
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.putProperty(key, (String)properties.get(key));
        }
    }

    protected abstract void createPart(Composite var1);

    private Map getProperties() {
        return this.properties;
    }

    protected String getProperty(String name) {
        String value = (String)this.properties.get(name);
        return value == null ? "" : value;
    }

    protected void putProperty(String name, String value) {
        this.properties.put(name, value);
        this.setConnectionURL(URLBuilder.createURL(this.urlPattern, this.getProperties()));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected JDBCDriver getDriver() {
        return this.driver;
    }

    public String getConnectionURL() {
        return this.connectionURL == null ? "" : this.connectionURL;
    }

    public void setConnectionURL(String connectionURL) {
        if (connectionURL != null && !connectionURL.equals(this.connectionURL)) {
            String original = this.connectionURL;
            this.connectionURL = connectionURL;
            this.firePropertyChange("connectionURL", original, connectionURL);
        }
    }
}

