/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.wizards;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.util.StringMatrix;
import com.quantum.wizards.BaseSQLPage;
import com.quantum.wizards.CommonWizardUI;
import com.quantum.wizards.SQLPage;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UpdateRowPage
extends BaseSQLPage
implements SQLPage {
    String[] columnNames;
    String[] colNames;
    Text query;
    UpdateRowTableValues[] updateTable = null;
    CommonWizardUI comUI;
    TableViewer tableViewer = null;
    static Image imgCheck = null;
    static Image imgUncheck = null;

    static {
        imgCheck = ImageStore.getImage("checked");
        imgUncheck = ImageStore.getImage("unchecked");
    }

    public UpdateRowPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.getString("TableView.UpdateRowTitle"));
        this.setDescription(Messages.getString("TableView.UpdateRowDesc"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1810));
        Entity entity = this.results.getEntity();
        this.comUI = new CommonWizardUI();
        this.columnNames = this.results.getColumnNames();
        int nLen = this.columnNames.length;
        this.updateTable = new UpdateRowTableValues[nLen];
        int nCtr = 0;
        while (nCtr < nLen) {
            Column column;
            this.updateTable[nCtr] = new UpdateRowTableValues();
            this.updateTable[nCtr].setSColNames(this.columnNames[nCtr]);
            Object data = this.row == null ? null : this.row.get(nCtr + 1);
            this.updateTable[nCtr].setSOldValue(data == null ? "" : data.toString());
            Column column2 = column = entity == null ? null : this.getColumn(entity, this.columnNames[nCtr]);
            if (column != null && column.isPrimaryKey()) {
                this.updateTable[nCtr].setBPrimary(true);
            }
            this.updateTable[nCtr].setSNewValue(data == null ? "" : data.toString());
            ++nCtr;
        }
        this.createTable(container);
        this.query = new Text(container, 586);
        this.query.setLayoutData((Object)this.comUI.createGridData(1, 10, 4));
        this.query.setVisible(false);
        this.setControl((Control)container);
        this.setPageComplete(true);
    }

    public void updateQuery() {
        this.query.setVisible(true);
        StringMatrix columns = new StringMatrix();
        ArrayList<Boolean> noQuote = new ArrayList<Boolean>();
        ArrayList<Boolean> noQuoteKey = new ArrayList<Boolean>();
        int i = 0;
        while (i < this.columnNames.length) {
            if (this.updateTable[i].isBSetValue()) {
                columns.addHeader(this.updateTable[i].getSColNames());
                columns.add(this.updateTable[i].getSNewValue(), 0);
                noQuote.add(new Boolean(this.updateTable[i].isNoQuote()));
            }
            ++i;
        }
        StringMatrix key = new StringMatrix();
        int i2 = 0;
        while (i2 < this.columnNames.length) {
            if (this.updateTable[i2].isBPrimary()) {
                key.addHeader(this.updateTable[i2].getSColNames());
                key.add(this.updateTable[i2].getSOldValue(), 0);
                noQuoteKey.add(new Boolean(this.updateTable[i2].isNoQuoteKey()));
            }
            ++i2;
        }
        Bookmark bookmark = (Bookmark)this.results.getConnectable();
        DatabaseAdapter adapter = bookmark.getAdapter();
        this.query.setText(adapter.buildUpdate(this.results.getEntity(), columns, key, noQuote, noQuoteKey));
    }

    protected String getQueryText() {
        return this.query.getText();
    }

    private void updateView() {
        this.tableViewer.update((Object[])this.updateTable, null);
    }

    private void createTable(Composite composite) {
        Table table = this.comUI.createTablePage(composite);
        this.colNames = new String[]{Messages.getString("UpdateRowPage.ColumnName"), Messages.getString("UpdateRowPage.OldValue"), "Where", Messages.getString("UpdateRowPage.NewValue"), Messages.getString("UpdateRowPage.SetValue"), "No Quote", "Key No Quote"};
        this.comUI.createTableColumn(table, this.colNames[0], 16384, 0, 150);
        this.comUI.createTableColumn(table, this.colNames[1], 16384, 1, 200);
        this.comUI.createTableColumn(table, this.colNames[2], 0x1000000, 2, 60);
        this.comUI.createTableColumn(table, this.colNames[3], 16384, 3, 200);
        this.comUI.createTableColumn(table, this.colNames[4], 0x1000000, 4, 70);
        this.comUI.createTableColumn(table, this.colNames[5], 0x1000000, 5, 50);
        this.comUI.createTableColumn(table, this.colNames[6], 0x1000000, 6, 50);
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setColumnProperties(this.colNames);
        CellEditor[] editor = new CellEditor[this.colNames.length];
        TextCellEditor txtEditorField = new TextCellEditor((Composite)table);
        txtEditorField.getControl().setEnabled(false);
        editor[0] = txtEditorField;
        TextCellEditor txtEditorFieldOld = new TextCellEditor((Composite)table);
        txtEditorFieldOld.getControl().setEnabled(false);
        editor[1] = txtEditorFieldOld;
        editor[2] = new CheckboxCellEditor((Composite)table, 0);
        TextCellEditor txtEditorValues = new TextCellEditor((Composite)table);
        editor[3] = txtEditorValues;
        editor[4] = new CheckboxCellEditor((Composite)table, 0);
        editor[5] = new CheckboxCellEditor((Composite)table, 0);
        editor[6] = new CheckboxCellEditor((Composite)table, 0);
        this.tableViewer.setCellEditors(editor);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.tableViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.tableViewer.setCellModifier((ICellModifier)new CellModifierImpl());
        this.tableViewer.setInput((Object)this.updateTable);
    }

    class UpdateRowTableValues {
        private String sColNames = null;
        private String sOldValue = null;
        private boolean bPrimary = false;
        private String sNewValue = null;
        private boolean bSetValue = false;
        private boolean noQuoteKey = false;
        private boolean noQuote = false;

        public boolean isNoQuoteKey() {
            return this.noQuoteKey;
        }

        public void setNoQuoteKey(boolean noQuoteKey) {
            this.noQuoteKey = noQuoteKey;
        }

        public boolean isNoQuote() {
            return this.noQuote;
        }

        public void setNoQuote(boolean noQuote) {
            this.noQuote = noQuote;
        }

        public boolean isBSetValue() {
            return this.bSetValue;
        }

        public void setBSetValue(boolean setValue) {
            this.bSetValue = setValue;
        }

        public boolean isBPrimary() {
            return this.bPrimary;
        }

        public void setBPrimary(boolean where) {
            this.bPrimary = where;
        }

        public String getSColNames() {
            return this.sColNames;
        }

        public void setSColNames(String colNames) {
            this.sColNames = colNames;
        }

        public String getSNewValue() {
            return this.sNewValue;
        }

        public void setSNewValue(String newValue) {
            this.sNewValue = newValue;
        }

        public String getSOldValue() {
            return this.sOldValue;
        }

        public void setSOldValue(String oldValue) {
            this.sOldValue = oldValue;
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 2) {
                return ((UpdateRowTableValues)element).isBPrimary() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 4) {
                return ((UpdateRowTableValues)element).isBSetValue() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 5) {
                return ((UpdateRowTableValues)element).isNoQuote() ? imgCheck : imgUncheck;
            }
            if (columnIndex == 6) {
                return ((UpdateRowTableValues)element).isNoQuoteKey() ? imgCheck : imgUncheck;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String sReturn = "";
            UpdateRowTableValues updateRow = (UpdateRowTableValues)element;
            switch (columnIndex) {
                case 0: {
                    sReturn = updateRow.getSColNames();
                    break;
                }
                case 1: {
                    sReturn = updateRow.getSOldValue();
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    sReturn = updateRow.getSNewValue();
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
            }
            return sReturn;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            return UpdateRowPage.this.updateTable;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class CellModifierImpl
    implements ICellModifier {
        CellModifierImpl() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            int colIndx = UpdateRowPage.this.comUI.getColumnNamesAsList(UpdateRowPage.this.colNames).indexOf(property);
            Object rResult = null;
            UpdateRowTableValues updateVal = (UpdateRowTableValues)element;
            switch (colIndx) {
                case 0: {
                    rResult = updateVal.getSColNames();
                    break;
                }
                case 1: {
                    rResult = updateVal.getSOldValue();
                    break;
                }
                case 2: {
                    rResult = new Boolean(updateVal.isBPrimary());
                    break;
                }
                case 3: {
                    rResult = updateVal.getSNewValue();
                    break;
                }
                case 4: {
                    rResult = new Boolean(updateVal.isBSetValue());
                    break;
                }
                case 5: {
                    rResult = new Boolean(updateVal.isNoQuote());
                    break;
                }
                case 6: {
                    rResult = new Boolean(updateVal.isNoQuoteKey());
                    break;
                }
            }
            return rResult;
        }

        public void modify(Object element, String property, Object value) {
            int colIndx = UpdateRowPage.this.comUI.getColumnNamesAsList(UpdateRowPage.this.colNames).indexOf(property);
            TableItem item = (TableItem)element;
            UpdateRowTableValues updateVal = (UpdateRowTableValues)item.getData();
            switch (colIndx) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    updateVal.setBPrimary((Boolean)value);
                    break;
                }
                case 3: {
                    if (updateVal.getSNewValue().equals(value.toString())) break;
                    updateVal.setSNewValue(value.toString());
                    updateVal.setBSetValue(true);
                    updateVal.setBPrimary(true);
                    break;
                }
                case 4: {
                    updateVal.setBSetValue((Boolean)value);
                    break;
                }
                case 5: {
                    updateVal.setNoQuote((Boolean)value);
                    break;
                }
                case 6: {
                    updateVal.setNoQuoteKey((Boolean)value);
                    break;
                }
            }
            UpdateRowPage.this.updateView();
            UpdateRowPage.this.updateQuery();
        }
    }
}

