/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.dbunit.wizard;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.dbunit.wizard.MyPrimaryKeyFilter;
import com.quantum.model.Bookmark;
import com.quantum.model.Entity;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.InputSource;

public class ConverterDBUnit {
    public void convert(FileOutputStream outputStream, Entity[] entities, String schema, boolean useDBSequence, boolean qualifyNames, Shell shell) throws Exception {
        if (entities.length < 1) {
            return;
        }
        Connection connection = entities[0].getBookmark().getConnection();
        DatabaseAdapter adapter = entities[0].getBookmark().getAdapter();
        if (connection == null) {
            return;
        }
        DatabaseConnection dbUnitConnection = schema != null ? new DatabaseConnection(connection, entities[0].getSchema()) : new DatabaseConnection(connection);
        DatabaseConfig config = dbUnitConnection.getConfig();
        if (!useDBSequence) {
            config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", (Object)new ForwardOnlyResultSetTableFactory());
        }
        if (entities[0].isSynonym()) {
            config.setProperty("http://www.dbunit.org/properties/tableType", (Object)new String[]{"SYNONYM"});
        } else if (entities[0].getType().equals("TABLE")) {
            config.setProperty("http://www.dbunit.org/properties/tableType", (Object)new String[]{"TABLE"});
        } else if (entities[0].getType().equals("VIEW")) {
            config.setProperty("http://www.dbunit.org/properties/tableType", (Object)new String[]{"VIEW"});
        }
        if (adapter.getType().equals("DB2")) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new Db2DataTypeFactory());
        } else if (adapter.getType().equals("ORACLE")) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new OracleDataTypeFactory());
        } else if (adapter.getType().equals("MYSQL")) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
        } else if (adapter.getType().equals("MS_SQL_SERVER")) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MsSqlDataTypeFactory());
        }
        DatabaseMetaData metadata = connection.getMetaData();
        boolean limitedDriver = false;
        try {
            metadata.getPrimaryKeys(null, null, null);
        }
        catch (SQLException sQLException) {
            limitedDriver = true;
            config.setProperty("http://www.dbunit.org/properties/primaryKeyFilter", (Object)new MyPrimaryKeyFilter());
        }
        catch (Exception exception) {}
        if (qualifyNames) {
            config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", true);
        }
        String[] tableNames = new String[entities.length];
        int i = 0;
        while (i < entities.length) {
            tableNames[i] = qualifyNames ? entities[i].getQualifiedName() : entities[i].getName();
            ++i;
        }
        IDataSet dataSet = null;
        if (limitedDriver || !useDBSequence) {
            dataSet = dbUnitConnection.createDataSet(tableNames);
        } else {
            DatabaseSequenceFilter filter = new DatabaseSequenceFilter((IDatabaseConnection)dbUnitConnection, tableNames);
            dataSet = new FilteredDataSet((ITableFilter)filter, dbUnitConnection.createDataSet());
        }
        try {
            FlatXmlDataSet.write((IDataSet)dataSet, (OutputStream)outputStream);
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)shell, (String)e.toString(), (String)e.getLocalizedMessage());
        }
    }

    public void convert(String fileName, Bookmark bookmark, String schema, boolean deletePreviousContent, boolean namesAreQualified) throws Exception {
        Connection connection = bookmark.getConnection();
        DatabaseConnection dbUnitConnection = null;
        DatabaseMetaData metadata = connection.getMetaData();
        dbUnitConnection = schema != null && !schema.equals("") && metadata.supportsSchemasInDataManipulation() && !namesAreQualified ? new DatabaseConnection(connection, schema) : new DatabaseConnection(connection);
        DatabaseConfig config = dbUnitConnection.getConfig();
        if (namesAreQualified) {
            config.setFeature("http://www.dbunit.org/features/qualifiedTableNames", true);
        }
        boolean limitedDriver = false;
        try {
            metadata.getPrimaryKeys(null, null, "");
        }
        catch (SQLException sQLException) {
            limitedDriver = true;
            config.setProperty("http://www.dbunit.org/properties/primaryKeyFilter", (Object)new MyPrimaryKeyFilter());
        }
        InputSource source = new InputSource(new File(fileName).toURL().toString());
        FlatXmlProducer producer = new FlatXmlProducer(source);
        StreamingDataSet insertDataSet = new StreamingDataSet((IDataSetProducer)producer);
        if (deletePreviousContent) {
            StreamingDataSet deleteDataSet = new StreamingDataSet((IDataSetProducer)producer);
            DatabaseOperation.DELETE_ALL.execute((IDatabaseConnection)dbUnitConnection, (IDataSet)deleteDataSet);
            DatabaseOperation.INSERT.execute((IDatabaseConnection)dbUnitConnection, (IDataSet)insertDataSet);
        } else if (limitedDriver) {
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConnection, (IDataSet)insertDataSet);
        } else {
            DatabaseOperation.REFRESH.execute((IDatabaseConnection)dbUnitConnection, (IDataSet)insertDataSet);
        }
    }
}

