/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;

public class CSVParser {
    private String line;
    private BufferedReader stream;
    private char[] eol;
    private StringBuffer actColumn = new StringBuffer();
    private char columnSeparator;
    private static final byte CLEAN_STATE = 0;
    private static final byte COMMENT_STATE = 1;
    private static final byte QUOTED_STATE = 2;
    private static final byte IN_QUOTE_STATE = 3;
    private static final byte CHARS_STATE = 4;

    CSVParser(BufferedReader stream, String eol, char columnSeparator) throws IOException {
        this.stream = stream;
        this.eol = eol.toCharArray();
        this.columnSeparator = columnSeparator;
    }

    int parse(Vector columns, Vector emptyStrings) throws IOException {
        if (this.eol.length < 1) {
            throw new IOException("No End-Of-Line defined");
        }
        int state = 0;
        int ic = 0;
        boolean endOfStream = false;
        columns.clear();
        emptyStrings.clear();
        while (ic >= 0) {
            ic = this.stream.read();
            endOfStream = ic < 0;
            char c = (char)ic;
            switch (state) {
                case 0: {
                    if (c == '\"') {
                        state = 2;
                        break;
                    }
                    if (c == this.columnSeparator) {
                        this.addColumn(columns, emptyStrings, new Boolean(false));
                        break;
                    }
                    if (c == '#') {
                        state = 1;
                        break;
                    }
                    state = 4;
                    this.actColumn.append(c);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (c == '\"') {
                        state = 3;
                        this.actColumn.append(c);
                        break;
                    }
                    this.actColumn.append(c);
                    break;
                }
                case 3: {
                    if (c == '\"') {
                        state = 2;
                        break;
                    }
                    if (c == this.columnSeparator) {
                        state = 0;
                        if (this.actColumn.length() > 0) {
                            this.actColumn.setLength(this.actColumn.length() - 1);
                        }
                        this.addColumn(columns, emptyStrings, new Boolean(true));
                        break;
                    }
                    if (c == '#') {
                        state = 1;
                        this.addColumn(columns, emptyStrings, new Boolean(false));
                        break;
                    }
                    throw new IOException("CSV Format Error :" + this.line);
                }
                case 4: {
                    if (c == '#') {
                        state = 1;
                        this.addColumn(columns, emptyStrings, new Boolean(false));
                        break;
                    }
                    if (c == this.columnSeparator) {
                        state = 0;
                        this.addColumn(columns, emptyStrings, new Boolean(false));
                        break;
                    }
                    this.actColumn.append(c);
                    break;
                }
            }
            if (state == 2 || c != this.eol[0] || !this.atEOL()) continue;
            if (this.actColumn.charAt(this.actColumn.length() - 1) == this.eol[0]) {
                this.actColumn.setLength(this.actColumn.length() - 1);
            }
            ic = -1;
        }
        if (state != 1) {
            this.addColumn(columns, emptyStrings, new Boolean(false));
        }
        return endOfStream ? 1 : 0;
    }

    private void addColumn(Vector columns, Vector nulls, Boolean isNull) {
        columns.add(this.actColumn.toString());
        nulls.add(isNull);
        this.actColumn.setLength(0);
    }

    private boolean atEOL() throws IOException {
        this.stream.mark(this.eol.length);
        boolean isEOL = true;
        int i = 1;
        while (i < this.eol.length) {
            int c = this.stream.read();
            if (c != this.eol[i]) {
                isEOL = false;
                this.stream.reset();
                break;
            }
            ++i;
        }
        return isEOL;
    }
}

