/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.csv.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.util.QuantumUtil;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.widget.SimpleLabelProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImportCSVDetailsPage
extends WizardPage {
    private String fileName;
    private boolean hasHeaderRow = false;
    private boolean ignoreHeaderRow = true;
    private boolean deletePreviousContent = false;
    private TableViewer tableViewer;
    private ContentProviderImpl contentProvider;
    private Button ignoreHeaderRowButton = null;
    private boolean isZip = false;
    private Vector matchedEntities = new Vector();
    List allSelectedTables = new Vector();
    private String eol = System.getProperty("line.separator");
    private char columnSeparator = (char)44;
    static /* synthetic */ Class class$0;

    protected void refreshTable() {
    }

    public void dispose() {
        super.dispose();
    }

    protected ImportCSVDetailsPage(String pageName) {
        super(pageName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setTitle(MessageUtil.getString(clazz, "title"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDescription(MessageUtil.getString(clazz2, "description"));
    }

    public void createControl(Composite parent) {
        final Composite parentf = parent;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "selectedEntities"));
        label.setLayoutData((Object)new GridData(2));
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider(ImageStore.getImage((String)"bigtable", (AbstractUIPlugin)QuantumPlugin.getDefault())));
        this.contentProvider = new ContentProviderImpl();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        List selectedTables = BookmarkView.getInstance().getSelection().toList();
        Iterator iter = selectedTables.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof GroupNode) {
                GroupNode groupNode = (GroupNode)element;
                this.allSelectedTables.addAll(Arrays.asList(groupNode.getChildren()));
                continue;
            }
            if (!(element instanceof EntityNode) || !((EntityNode)element).isTable()) continue;
            this.allSelectedTables.add(element);
        }
        this.tableViewer.setInput((Object)this.matchedEntities);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        Group group = new Group(composite, 0);
        Composite groupIn = new Composite((Composite)group, 0);
        groupIn.setLayout((Layout)new GridLayout(2, false));
        groupIn.setLayoutData((Object)new GridData(768));
        label = new Label(groupIn, 0);
        label.setText("End-of-Line characters (OS default): ");
        Text eolText = new Text(groupIn, 2048);
        eolText.setLayoutData((Object)new GridData(768));
        eolText.setText(QuantumUtil.unTrasposeEscape((String)this.eol));
        eolText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ImportCSVDetailsPage.this.setEol(((Text)event.getSource()).getText());
                ImportCSVDetailsPage.this.updateState();
            }
        });
        new Label(groupIn, 0).setText("Column separator:");
        Text columnSeparatorText = new Text(groupIn, 2048);
        columnSeparatorText.setText(",");
        columnSeparatorText.setTextLimit(1);
        columnSeparatorText.setLayoutData((Object)new GridData(768));
        columnSeparatorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String columnSeparatorStr = ((Text)event.getSource()).getText();
                if (columnSeparatorStr.length() != 1) {
                    ((Text)event.getSource()).setBackground(parentf.getDisplay().getSystemColor(3));
                } else {
                    ((Text)event.getSource()).setBackground(parentf.getDisplay().getSystemColor(1));
                }
                if (columnSeparatorStr.length() > 0) {
                    ImportCSVDetailsPage.this.columnSeparator = columnSeparatorStr.charAt(0);
                } else {
                    ImportCSVDetailsPage.this.columnSeparator = ',';
                }
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        group.setText(MessageUtil.getString(clazz2, "options"));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Button headerRow = new Button((Composite)group, 32);
        this.ignoreHeaderRowButton = new Button((Composite)group, 32);
        this.changeButtonActive(this.hasHeaderRow, this.ignoreHeaderRowButton);
        Button deletePreviousContentButton = new Button((Composite)group, 32);
        headerRow.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "headerRow"));
        headerRow.setSelection(this.hasHeaderRow);
        headerRow.setLayoutData((Object)new GridData(32));
        headerRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportCSVDetailsPage.this.hasHeaderRow = ((Button)event.getSource()).getSelection();
                ImportCSVDetailsPage.this.changeButtonActive(ImportCSVDetailsPage.this.hasHeaderRow, ImportCSVDetailsPage.this.ignoreHeaderRowButton);
            }
        });
        this.ignoreHeaderRowButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "ignoreHeaderRowButton"));
        this.ignoreHeaderRowButton.setSelection(this.ignoreHeaderRow);
        this.ignoreHeaderRowButton.setLayoutData((Object)new GridData(32));
        this.ignoreHeaderRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportCSVDetailsPage.this.ignoreHeaderRow = ((Button)event.getSource()).getSelection();
            }
        });
        deletePreviousContentButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "deletePreviousContentButton"));
        deletePreviousContentButton.setSelection(this.deletePreviousContent);
        deletePreviousContentButton.setLayoutData((Object)new GridData(32));
        deletePreviousContentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImportCSVDetailsPage.this.deletePreviousContent = ((Button)event.getSource()).getSelection();
                if (ImportCSVDetailsPage.this.deletePreviousContent) {
                    MessageDialog.openInformation((Shell)ImportCSVDetailsPage.this.getShell(), (String)"Important Warning", (String)"This will delete ALL your data in the imported tables. Think 'bout it.");
                }
            }
        });
        Label blankArea = new Label(composite, 0);
        blankArea.setText("");
        this.createDestinationArea(composite);
        this.setControl((Control)composite);
        this.updateState();
    }

    private void changeButtonActive(boolean value, Button button) {
        if (!value) {
            button.setSelection(false);
            button.setEnabled(false);
        } else {
            button.setEnabled(true);
        }
    }

    private void createDestinationArea(Composite composite) {
        Composite fileArea = new Composite(composite, 0);
        fileArea.setLayout((Layout)new GridLayout(3, false));
        fileArea.setLayoutData((Object)new GridData(770));
        Label label = new Label(fileArea, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "fileName"));
        final Text fileNameText = new Text(fileArea, 2048);
        fileNameText.setLayoutData((Object)new GridData(768));
        fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String filename = ((Text)event.getSource()).getText();
                ImportCSVDetailsPage.this.setFileName(filename);
                ImportCSVDetailsPage.this.updateState();
            }
        });
        Button button = new Button(fileArea, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        button.setText(MessageUtil.getString(clazz2, "browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ImportCSVDetailsPage.this.getShell(), 8192);
                String extension = "*.zip;*.csv";
                dialog.setFilterExtensions(new String[]{extension});
                String[] stringArray = new String[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.quantum.csv.wizard.ImportCSVDetailsPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                stringArray[0] = MessageUtil.getString(clazz, "zip+csvFiles");
                dialog.setFilterNames(stringArray);
                String filename = dialog.open();
                if (filename != null) {
                    fileNameText.setText(filename);
                    ImportCSVDetailsPage.this.setFileName(filename);
                    ImportCSVDetailsPage.this.updateState();
                }
            }
        });
    }

    protected void updateState() {
        boolean pageComplete = this.fileName != null && !new File(this.fileName).isDirectory();
        Vector<String> fileNames = new Vector<String>();
        if (pageComplete) {
            String extension = "";
            int lastPoint = this.fileName.lastIndexOf(46);
            if (lastPoint >= 0 && lastPoint < this.fileName.length()) {
                extension = this.fileName.substring(lastPoint + 1);
            }
            pageComplete &= extension.equals("zip") || extension.equals("csv");
            if (extension.equals("zip")) {
                this.isZip = true;
                try {
                    ZipFile zipFile = new ZipFile(this.fileName);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry zipEntry = entries.nextElement();
                        fileNames.add(this.stripExtension(zipEntry.getName()));
                    }
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.isZip = false;
                if (extension.equals("csv")) {
                    fileNames.add(this.stripExtension(this.fileName));
                }
            }
            this.matchedEntities.clear();
            if (fileNames.size() == 1 && this.allSelectedTables.size() == 1) {
                this.matchedEntities.addAll(this.allSelectedTables);
            } else if (fileNames.size() > 0) {
                Iterator iter = fileNames.iterator();
                while (iter.hasNext()) {
                    String fileName = (String)iter.next();
                    Iterator iterator = this.allSelectedTables.iterator();
                    while (iterator.hasNext()) {
                        EntityNode element = (EntityNode)iterator.next();
                        if (!element.getName().equals(fileName)) continue;
                        this.matchedEntities.add(element);
                    }
                }
            }
            this.tableViewer.refresh();
        }
        this.setPageComplete(pageComplete);
    }

    private String stripExtension(String name) {
        int lastPoint = name.lastIndexOf(46);
        if (lastPoint >= 0) {
            return name.substring(0, lastPoint);
        }
        return name;
    }

    public boolean deletePreviousContent() {
        return this.deletePreviousContent;
    }

    public void setDeletePreviousContent(boolean deletePreviousContent) {
        this.deletePreviousContent = deletePreviousContent;
    }

    public boolean ignoreHeaderRow() {
        return this.ignoreHeaderRow;
    }

    public void setIgnoreHeaderRow(boolean ignoreHeaderRow) {
        this.ignoreHeaderRow = ignoreHeaderRow;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    public void setWriteHeaderRow(boolean writeHeaderRow) {
        this.hasHeaderRow = writeHeaderRow;
    }

    public boolean isZip() {
        return this.isZip;
    }

    public Vector getMatchedEntities() {
        return this.matchedEntities;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public String getEol() {
        return this.eol;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public class ContentProviderImpl
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StructuredSelection) {
                Object[] entities = ((StructuredSelection)inputElement).toArray();
                return entities;
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

