/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.converter;

import com.quantum.flatfiles.converter.Converter;
import com.quantum.sql.SQLDate;
import com.quantum.sql.SQLNull;
import com.quantum.sql.SQLResultSetResults;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

class ResultSetToSpreadSheetConverter
implements Converter {
    ResultSetToSpreadSheetConverter() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convert(String spreadSheetFileName, SQLResultSetResults results) throws IOException {
        HSSFWorkbook workbook = this.createWorkbook(results);
        FileOutputStream output = new FileOutputStream(spreadSheetFileName);
        try {
            workbook.write((OutputStream)output);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            output.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        output.close();
    }

    private HSSFWorkbook createWorkbook(SQLResultSetResults results) {
        SQLResultSetResults.Column[] columns = results.getColumns();
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet();
        int rowNumber = this.createColumnHeadings(results, sheet);
        Iterator i = results.getRowIterator();
        while (i.hasNext()) {
            SQLResultSetResults.Row row = (SQLResultSetResults.Row)i.next();
            HSSFRow spreadSheetRow = sheet.createRow(rowNumber++);
            int j = 1;
            int length = columns == null ? 0 : columns.length;
            while (j <= length) {
                Object cellValue = row.get(j);
                HSSFCell cell = spreadSheetRow.createCell((short)(j - 1));
                if (cellValue != null && !(cellValue instanceof SQLNull)) {
                    if (cellValue instanceof String) {
                        cell.setCellValue((String)cellValue);
                    } else if (cellValue instanceof SQLDate) {
                        cell.setCellValue(((SQLDate)cellValue).getDate());
                    } else if (cellValue instanceof Date) {
                        cell.setCellValue((Date)cellValue);
                    } else if (cellValue instanceof Number) {
                        cell.setCellValue(((Number)cellValue).doubleValue());
                    } else if (cellValue instanceof Boolean) {
                        cell.setCellValue(((Boolean)cellValue).toString());
                    } else {
                        cell.setCellValue(cellValue.toString());
                    }
                }
                ++j;
            }
        }
        return workbook;
    }

    private int createColumnHeadings(SQLResultSetResults results, HSSFSheet sheet) {
        HSSFRow row = sheet.createRow(0);
        int i = 1;
        int length = results == null ? 0 : results.getColumnCount();
        while (i <= length) {
            HSSFCell cell = row.createCell((short)(i - 1));
            cell.setCellValue(results.getColumnName(i));
            ++i;
        }
        return 1;
    }

    public String getFileExtension() {
        return ".xls";
    }
}

