/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.wizard.ExportDDLWizardFileSelectionPage;
import com.quantum.flatfiles.wizard.ExportDatabaseObjectsWizardPage;
import com.quantum.flatfiles.wizard.InputStreamProvider;
import com.quantum.flatfiles.wizard.SelectBookmarkWizardPage;
import com.quantum.model.Bookmark;
import com.quantum.model.Table;
import com.quantum.model.TableMetadata;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.Displayable;
import com.quantum.util.StringUtil;
import com.quantum.util.connection.ConnectionException;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.versioning.VersioningHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.SQLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportDDLWizard
extends Wizard
implements IExportWizard,
InputStreamProvider,
PropertyChangeListener {
    private ExportDDLWizardFileSelectionPage outputPage;
    private ExportDatabaseObjectsWizardPage objectsPage;
    private SelectBookmarkWizardPage bookmarkPage;

    public ExportDDLWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.bookmarkPage = new SelectBookmarkWizardPage("bookmark");
        this.bookmarkPage.addPropertyChangeListener(this);
        this.objectsPage = new ExportDatabaseObjectsWizardPage("objects");
        this.outputPage = new ExportDDLWizardFileSelectionPage("outputLocation", this);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.bookmarkPage);
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.outputPage);
    }

    public InputStream getInputStream() {
        StringBuffer buffer = new StringBuffer();
        Bookmark bookmark = this.objectsPage.getBookmark();
        try {
            Object[] exports = this.objectsPage.getCheckedElements();
            int i = 0;
            int length = exports == null ? 0 : exports.length;
            while (i < length) {
                if (exports[i] instanceof Table) {
                    Table table = (Table)exports[i];
                    this.appendTableData(buffer, bookmark, table);
                }
                ++i;
            }
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException((Shell)this.getShell(), (Displayable)bookmark, (SQLException)e);
        }
        catch (ConnectionException e) {
            ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
        }
        return new ByteArrayInputStream(buffer.toString().getBytes());
    }

    private void appendTableData(StringBuffer buffer, Bookmark bookmark, Table table) throws NotConnectedException, SQLException {
        buffer.append("-- table ");
        buffer.append(table.getQuotedTableName());
        buffer.append(StringUtil.LINE_SEPARATOR);
        buffer.append(bookmark.getAdapter().buildCreateTable(bookmark, (TableMetadata)table, bookmark.getDatabase().supportsSchemasInTableDefinitions() ? bookmark.getSchema(table.getSchema()) : bookmark.getDefaultSchema(), false));
    }

    public boolean performFinish() {
        Object file = this.outputPage.createOutputFile();
        if (file != null && file instanceof IFile) {
            VersioningHelper.openEditor((Shell)this.getShell(), (IFile)((IFile)file));
        }
        return true;
    }

    public void dispose() {
        this.bookmarkPage.removePropertyChangeListener(this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("bookmark".equals(event.getPropertyName())) {
            this.objectsPage.setBookmark((Bookmark)event.getNewValue());
        }
    }
}

