/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.converter.Converter;
import com.quantum.flatfiles.converter.ConverterFactory;
import com.quantum.flatfiles.wizard.ExportResultSetDataWizardPage;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ExportResultSetDataWizard
extends Wizard {
    private SQLResultSetResults resultSet;
    private ExportResultSetDataWizardPage page;

    public ExportResultSetDataWizard(SQLResultSetResults resultSet) {
        this.resultSet = resultSet;
        this.setWindowTitle(MessageUtil.getString(((Object)((Object)this)).getClass(), "windowTitle"));
    }

    public boolean performFinish() {
        boolean done = false;
        try {
            String fileName = this.page.getFileName();
            File file = new File(fileName);
            if (!file.exists()) {
                this.export(fileName);
                done = true;
            } else if (this.page.overwriteFile() || MessageDialog.openQuestion((Shell)this.getShell(), (String)MessageUtil.getString(((Object)((Object)this)).getClass(), "overwriteTitle"), (String)MessageUtil.getString(((Object)((Object)this)).getClass(), "overwriteMessage", new String[]{fileName}))) {
                this.export(fileName);
                done = true;
            }
        }
        catch (IOException e) {
            ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
        }
        return done;
    }

    private void export(String fileName) throws IOException {
        Converter converter = ConverterFactory.getConverter(this.page.getExportType());
        converter.convert(fileName, this.resultSet);
    }

    public void addPages() {
        this.page = new ExportResultSetDataWizardPage("page1", this.resultSet);
        this.addPage((IWizardPage)this.page);
    }
}

