/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.flatfiles.MessageUtil;
import com.quantum.flatfiles.QuantumFlatFilesPlugin;
import com.quantum.flatfiles.wizard.ExportDetailsPage;
import com.quantum.flatfiles.wizard.SelectBookmarkWizardPage;
import com.quantum.flatfiles.wizard.TorqueConverter;
import com.quantum.model.Bookmark;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.Displayable;
import com.quantum.util.connection.NotConnectedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportTorqueWizard
extends Wizard
implements IExportWizard,
PropertyChangeListener {
    private SelectBookmarkWizardPage page1;
    private ExportDetailsPage page2;

    public ExportTorqueWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor((String)"export_torque", (AbstractUIPlugin)QuantumFlatFilesPlugin.getDefault()));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        boolean successful = false;
        File file = new File(this.page2.getFileName());
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        boolean confirmOverwrite = store.getBoolean("com.quantum.export.confirmOverwrite");
        if (file.exists() && confirmOverwrite) {
            if (!file.exists()) return successful;
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)MessageUtil.getString(this.getClass(), "overwriteTitle"), (String)MessageUtil.getString(this.getClass(), "confirmOverwrite", new Object[]{file.getAbsoluteFile()}))) return successful;
        }
        try {
            FileWriter writer = new FileWriter(file);
            try {
                TorqueConverter converter = new TorqueConverter();
                converter.convert(writer, this.page2.getBookmark(), this.page2.getSchema(), this.page2.getDatabaseName(), this.page2.getIdMethod());
                successful = true;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var7_12 = null;
                writer.close();
                return successful;
            }
        }
        catch (IOException e) {
            ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            return successful;
        }
        catch (NotConnectedException e) {
            ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            return successful;
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException((Shell)this.getShell(), (Displayable)this.page2.getBookmark(), (SQLException)e);
        }
        return successful;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new SelectBookmarkWizardPage("page1");
        this.page1.addPropertyChangeListener(this);
        this.page2 = new ExportDetailsPage("page2");
    }

    public void dispose() {
        this.page1.removePropertyChangeListener(this);
        super.dispose();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("bookmark".equals(event.getPropertyName())) {
            this.page2.setBookmark((Bookmark)event.getNewValue());
        }
    }
}

