/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.flatfiles.wizard;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class SimpleCheckStateListener
implements ICheckStateListener {
    private final ITreeContentProvider contentProvider;
    private final CheckboxTreeViewer viewer;

    public SimpleCheckStateListener(CheckboxTreeViewer viewer) {
        this.viewer = viewer;
        this.contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        this.viewer.setSubtreeChecked(element, event.getChecked());
        Object parent = this.contentProvider.getParent(element);
        if (parent != null) {
            Object[] siblings = this.contentProvider.getChildren(parent);
            boolean someAreChecked = false;
            boolean someAreNotChecked = false;
            int i = 0;
            int length = siblings == null ? 0 : siblings.length;
            while (i < length) {
                someAreChecked |= this.viewer.getChecked(siblings[i]);
                someAreNotChecked |= !this.viewer.getChecked(siblings[i]);
                ++i;
            }
            this.viewer.setGrayed(parent, someAreChecked && someAreNotChecked);
            this.viewer.setChecked(parent, someAreChecked);
        }
    }
}

