/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.MercurialEclipsePlugin;
import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.ChangeSet;
import com.vectrace.MercurialEclipse.model.FileStatus;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.storage.HgRepositoryLocation;
import com.vectrace.MercurialEclipse.team.MercurialTeamProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractParseChangesetClient
extends AbstractClient {
    private static final String STYLE_SRC = "/styles/log_style";
    private static final String STYLE = "/log_style";
    private static final String STYLE_WITH_FILES_SRC = "/styles/log_style_with_files";
    private static final String STYLE_WITH_FILES = "/log_style_with_files";
    private static final String STYLE_TEMP_EXTN = ".tmpl";
    private static ContentHandler handler;

    AbstractParseChangesetClient() {
    }

    protected static File getStyleFile(boolean withFiles) throws HgException {
        String style_src;
        String style;
        if (!withFiles) {
            style = STYLE;
            style_src = STYLE_SRC;
        } else {
            style = STYLE_WITH_FILES;
            style_src = STYLE_WITH_FILES_SRC;
        }
        String style_tmpl = String.valueOf(style) + STYLE_TEMP_EXTN;
        String style_tmpl_src = String.valueOf(style_src) + STYLE_TEMP_EXTN;
        IPath sl = MercurialEclipsePlugin.getDefault().getStateLocation();
        File stylefile = sl.append(style).toFile();
        File tmplfile = sl.append(style_tmpl).toFile();
        if (stylefile.canRead() && tmplfile.canRead()) {
            stylefile.deleteOnExit();
            tmplfile.deleteOnExit();
            return stylefile;
        }
        ClassLoader cl = AbstractParseChangesetClient.class.getClassLoader();
        InputStream styleistr = cl.getResourceAsStream(style_src);
        InputStream tmplistr = cl.getResourceAsStream(style_tmpl_src);
        FileOutputStream styleostr = null;
        FileOutputStream tmplostr = null;
        try {
            int n;
            styleostr = new FileOutputStream(stylefile);
            tmplostr = new FileOutputStream(tmplfile);
            tmplfile.deleteOnExit();
            byte[] buffer = new byte[1024];
            while ((n = styleistr.read(buffer)) != -1) {
                ((OutputStream)styleostr).write(buffer, 0, n);
            }
            while ((n = tmplistr.read(buffer)) != -1) {
                ((OutputStream)tmplostr).write(buffer, 0, n);
            }
            File file = stylefile;
            return file;
        }
        catch (IOException e) {
            throw new HgException("Failed to setup hg style file", e);
        }
        finally {
            try {
                if (styleostr != null) {
                    ((OutputStream)styleostr).close();
                }
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
            try {
                if (tmplostr != null) {
                    ((OutputStream)tmplostr).close();
                }
            }
            catch (IOException e) {
                MercurialEclipsePlugin.logError(e);
            }
        }
    }

    protected static final Map<IPath, SortedSet<ChangeSet>> createMercurialRevisions(IResource res, String input, boolean withFiles, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, IFilePatch[] patches) throws HgException {
        HgRoot hgRoot = MercurialTeamProvider.getHgRoot(res);
        IPath path = res.getLocation();
        return AbstractParseChangesetClient.createMercurialRevisions(path, input, direction, repository, bundleFile, patches, hgRoot);
    }

    protected static Map<IPath, SortedSet<ChangeSet>> createMercurialRevisions(IPath path, String input, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, IFilePatch[] patches, HgRoot hgRoot) throws HgException {
        HashMap<IPath, SortedSet<ChangeSet>> fileRevisions = new HashMap<IPath, SortedSet<ChangeSet>>();
        if (input == null || input.length() == 0) {
            return fileRevisions;
        }
        String myInput = "<top>" + input + "</top>";
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(AbstractParseChangesetClient.getHandler(path, direction, repository, bundleFile, hgRoot, fileRevisions, patches));
            reader.parse(new InputSource(new StringReader(myInput)));
        }
        catch (Exception e) {
            String nextTry = AbstractParseChangesetClient.cleanControlChars(myInput);
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader();
                reader.setContentHandler(AbstractParseChangesetClient.getHandler(path, direction, repository, bundleFile, hgRoot, fileRevisions, patches));
                reader.parse(new InputSource(new StringReader(nextTry)));
            }
            catch (Exception e1) {
                throw new HgException(e1.getLocalizedMessage(), e);
            }
        }
        return fileRevisions;
    }

    private static ContentHandler getHandler(IPath res, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, HgRoot hgRoot, Map<IPath, SortedSet<ChangeSet>> fileRevisions, IFilePatch[] patches) {
        handler = new ChangesetContentHandler(res, direction, repository, bundleFile, hgRoot, fileRevisions, patches);
        return handler;
    }

    private static String cleanControlChars(String str) {
        StringBuilder buf = new StringBuilder();
        int len = str.length();
        int i = 0;
        while (i < len) {
            int ch = str.codePointAt(i);
            if (ch == 13 || ch == 10 || ch == 9) {
                buf.appendCodePoint(ch);
            } else if (Character.isISOControl(ch)) {
                buf.append(' ');
            } else if (ch == 38) {
                buf.append("&amp;");
            } else if (ch == 34) {
                buf.append("\"");
            } else {
                buf.appendCodePoint(ch);
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChangesetContentHandler
    implements ContentHandler {
        private static final String[] EMPTY = new String[0];
        private String br;
        private String tg;
        private int rv;
        private String ns;
        private String nl;
        private String di;
        private String da;
        private String au;
        private String pr;
        private String de;
        private StringBuilder chars;
        private final IPath res;
        private final ChangeSet.Direction direction;
        private final HgRepositoryLocation repository;
        private final File bundleFile;
        private final HgRoot hgRoot;
        private final Map<IPath, SortedSet<ChangeSet>> fileRevisions;
        private final Set<String> filesModified = new TreeSet<String>();
        private final Set<String> filesAdded = new TreeSet<String>();
        private final Set<String> filesRemoved = new TreeSet<String>();
        private FileStatus.Action action;
        private final IFilePatch[] patches;
        private static final Pattern LT = Pattern.compile("&lt;");
        private static final Pattern GT = Pattern.compile("&gt;");
        private static final Pattern AMP = Pattern.compile("&amp;");
        private static final Pattern NEWLINE_TAB = Pattern.compile("\n\t");
        private static final Pattern WORDS = Pattern.compile(" ");

        public ChangesetContentHandler(IPath res, ChangeSet.Direction direction, HgRepositoryLocation repository, File bundleFile, HgRoot hgRoot, Map<IPath, SortedSet<ChangeSet>> fileRevisions, IFilePatch[] patches) {
            this.res = res;
            this.direction = direction;
            this.repository = repository;
            this.bundleFile = bundleFile;
            this.hgRoot = hgRoot;
            this.fileRevisions = fileRevisions;
            this.patches = patches;
        }

        private static String replaceAll(Pattern p, String source, String replacement) {
            return p.matcher(source).replaceAll(replacement);
        }

        private static String unescape(String string) {
            String result = ChangesetContentHandler.replaceAll(LT, string, "<");
            result = ChangesetContentHandler.replaceAll(GT, result, ">");
            return ChangesetContentHandler.replaceAll(AMP, result, "&");
        }

        private static String untab(String string) {
            return ChangesetContentHandler.replaceAll(NEWLINE_TAB, string, "\n");
        }

        private static String[] splitWords(String string) {
            if (string == null || string.length() == 0) {
                return EMPTY;
            }
            return WORDS.split(string);
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.chars.append(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (name.equals("de")) {
                this.de = this.chars.toString();
            } else if (name.equals("cs")) {
                ChangeSet.Builder csb = new ChangeSet.Builder(this.rv, this.nl, this.br, this.di, ChangesetContentHandler.unescape(this.au), this.hgRoot);
                csb.tag(this.tg);
                csb.nodeShort(this.ns);
                csb.ageDate(this.da);
                csb.description(ChangesetContentHandler.untab(ChangesetContentHandler.unescape(this.de)));
                csb.parents(ChangesetContentHandler.splitWords(this.pr));
                csb.bundleFile(this.bundleFile);
                csb.direction(this.direction);
                csb.repository(this.repository);
                csb.patches(this.patches);
                ArrayList<FileStatus> list = new ArrayList<FileStatus>();
                for (String file : this.filesModified) {
                    list.add(new FileStatus(FileStatus.Action.MODIFIED, file));
                }
                for (String file : this.filesAdded) {
                    list.add(new FileStatus(FileStatus.Action.ADDED, file));
                }
                for (String file : this.filesRemoved) {
                    list.add(new FileStatus(FileStatus.Action.REMOVED, file));
                }
                csb.changedFiles(list.toArray(new FileStatus[list.size()]));
                ChangeSet changeSet = csb.build();
                this.addChangesetToResourceMap(changeSet);
                this.filesModified.clear();
                this.filesAdded.clear();
                this.filesRemoved.clear();
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.chars = new StringBuilder(42);
            if (name.equals("br")) {
                this.br = atts.getValue(0);
            } else if (name.equals("tg")) {
                this.tg = atts.getValue(0);
            } else if (name.equals("rv")) {
                this.rv = Integer.parseInt(atts.getValue(0));
            } else if (name.equals("ns")) {
                this.ns = atts.getValue(0);
            } else if (name.equals("nl")) {
                this.nl = atts.getValue(0);
            } else if (name.equals("di")) {
                this.di = atts.getValue(0);
            } else if (name.equals("da")) {
                this.da = atts.getValue(0);
            } else if (name.equals("au")) {
                this.au = atts.getValue(0);
            } else if (name.equals("pr")) {
                this.pr = atts.getValue(0);
            } else if (name.equals("fl")) {
                this.action = FileStatus.Action.MODIFIED;
            } else if (name.equals("fa")) {
                this.action = FileStatus.Action.ADDED;
            } else if (name.equals("fd")) {
                this.action = FileStatus.Action.REMOVED;
            } else if (name.equals("f")) {
                if (this.action == FileStatus.Action.ADDED) {
                    this.filesAdded.add(atts.getValue(0));
                    this.filesModified.remove(atts.getValue(0));
                } else if (this.action == FileStatus.Action.MODIFIED) {
                    this.filesModified.add(atts.getValue(0));
                } else if (this.action == FileStatus.Action.REMOVED) {
                    this.filesRemoved.add(atts.getValue(0));
                    this.filesModified.remove(atts.getValue(0));
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        private final void addChangesetToResourceMap(ChangeSet cs) {
            Path repoPath = new Path(cs.getHgRoot().getPath());
            if (cs.getChangedFiles() != null) {
                FileStatus[] fileStatusArray = cs.getChangedFiles();
                int n = fileStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileStatus file = fileStatusArray[n2];
                    IPath fileAbsPath = repoPath.append(file.getPath());
                    SortedSet<ChangeSet> revs = this.addChangeSetRevisions(cs, fileAbsPath);
                    this.fileRevisions.put(fileAbsPath, revs);
                    ++n2;
                }
            }
            SortedSet<ChangeSet> projectRevs = this.addChangeSetRevisions(cs, (IPath)repoPath);
            this.fileRevisions.put((IPath)repoPath, projectRevs);
            SortedSet<ChangeSet> pathRevs = this.addChangeSetRevisions(cs, this.res);
            this.fileRevisions.put(this.res, pathRevs);
        }

        private SortedSet<ChangeSet> addChangeSetRevisions(ChangeSet cs, IPath path) {
            SortedSet<ChangeSet> fileRevs = this.fileRevisions.get(path);
            if (fileRevs == null) {
                fileRevs = new TreeSet<ChangeSet>();
            }
            fileRevs.add(cs);
            return fileRevs;
        }
    }
}

