/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.model.HgRoot;
import com.vectrace.MercurialEclipse.team.MercurialUtilities;
import com.vectrace.MercurialEclipse.utils.ResourceUtils;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class HgCatClient
extends AbstractClient {
    public static String getContent(IFile resource, String revision) throws HgException {
        HgRoot hgRoot = HgCatClient.getHgRoot((IResource)resource);
        File file = ResourceUtils.getFileHandle((IResource)resource);
        HgCommand command = new HgCommand("cat", (File)hgRoot, true);
        if (revision != null && revision.length() != 0) {
            command.addOptions("--rev", revision);
        }
        command.addOptions("--decode");
        command.addOptions(hgRoot.toRelative(file));
        return command.executeToString();
    }

    public static String getContentFromBundle(IFile resource, String revision, String overlayBundle) throws HgException {
        HgRoot hgRoot = HgCatClient.getHgRoot((IResource)resource);
        File file = ResourceUtils.getFileHandle((IResource)resource);
        ArrayList<String> command = new ArrayList<String>();
        command.add(MercurialUtilities.getHGExecutable());
        command.add("-R");
        command.add(overlayBundle);
        command.add("cat");
        if (revision != null && revision.length() != 0) {
            command.add("-r");
            command.add("tip");
        }
        command.add("--decode");
        command.add(hgRoot.toRelative(file));
        HgCommand hgCommand = new HgCommand(command, (File)hgRoot, true);
        return hgCommand.executeToString();
    }
}

