/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.commands.AbstractClient;
import com.vectrace.MercurialEclipse.commands.HgCommand;
import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.utils.PatchUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgPatchClient
extends AbstractClient {
    public static String importPatch(IProject project, File patchLocation, ArrayList<String> options) throws HgException {
        assert (patchLocation != null && options != null);
        HgCommand command = new HgCommand("import", (IContainer)project, true);
        command.addFiles(patchLocation.getAbsolutePath());
        command.addOptions(options.toArray(new String[options.size()]));
        return command.executeToString();
    }

    public static boolean exportPatch(File workDir, List<IResource> resources, File patchFile, ArrayList<String> options) throws HgException {
        HgCommand command = new HgCommand("diff", HgPatchClient.getWorkingDirectory(workDir), true);
        command.addFiles(resources);
        command.addOptions(options.toArray(new String[options.size()]));
        return command.executeToFile(patchFile, 0, false);
    }

    public static String exportPatch(File workDir, List<IResource> resources, ArrayList<String> options) throws HgException {
        HgCommand command = new HgCommand("diff", HgPatchClient.getWorkingDirectory(workDir), true);
        command.addFiles(resources);
        command.addOptions(options.toArray(new String[options.size()]));
        return command.executeToString();
    }

    public static String getDiff(File workDir) throws HgException {
        HgCommand command = new HgCommand("diff", HgPatchClient.getWorkingDirectory(workDir), true);
        return command.executeToString();
    }

    public static String getDiff(File workDir, File file) throws HgException {
        HgCommand command = new HgCommand("diff", HgPatchClient.getWorkingDirectory(workDir), true);
        command.addOptions(file.getAbsolutePath());
        return command.executeToString();
    }

    public IFilePatch[] getFilePatchesFromDiff(File file) throws HgException {
        HgCommand command = new HgCommand("diff", HgPatchClient.getWorkingDirectory(HgPatchClient.getWorkingDirectory(file)), true);
        String patchString = command.executeToString();
        return PatchUtils.getFilePatches(patchString);
    }
}

