/*
 * Decompiled with CFR 0.152.
 */
package com.vectrace.MercurialEclipse.commands;

import com.vectrace.MercurialEclipse.exception.HgException;
import com.vectrace.MercurialEclipse.utils.IniFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgPathsClient {
    public static final String DEFAULT = "default";
    public static final String DEFAULT_PULL = "default-pull";
    public static final String DEFAULT_PUSH = "default-push";
    public static final String PATHS_LOCATION = "/.hg/hgrc";
    public static final String PATHS_SECTION = "paths";

    public static Map<String, String> getPaths(IProject project) throws HgException {
        File hgrc = new File(project.getLocation() + PATHS_LOCATION);
        if (!hgrc.exists()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> paths = new HashMap<String, String>();
        try {
            FileInputStream input = new FileInputStream(hgrc);
            IniFile ini = new IniFile(hgrc.toURL());
            Map<String, String> section = ini.getSection(PATHS_SECTION);
            if (section != null) {
                paths.putAll(section);
            }
            input.close();
        }
        catch (IOException e) {
            throw new HgException("Unable to read paths", e);
        }
        return paths;
    }
}

